rule win_unidentified_088_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_088."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_088"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c8ff 89442404 891c24 e8???????? 8b4510 6bdb0c 031e }
            // n = 7, score = 100
            //   83c8ff               | or                  eax, 0xffffffff
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   6bdb0c               | imul                ebx, ebx, 0xc
            //   031e                 | add                 ebx, dword ptr [esi]

        $sequence_1 = { c705????????04000000 c705????????208d4200 c705????????5beb4100 c705????????60154200 c605????????01 c705????????08000000 }
            // n = 6, score = 100
            //   c705????????04000000     |     
            //   c705????????208d4200     |     
            //   c705????????5beb4100     |     
            //   c705????????60154200     |     
            //   c605????????01       |                     
            //   c705????????08000000     |     

        $sequence_2 = { c705????????20124200 c605????????01 c705????????20000000 c705????????00ac4200 c705????????12ea4100 c705????????02000000 c605????????02 }
            // n = 7, score = 100
            //   c705????????20124200     |     
            //   c605????????01       |                     
            //   c705????????20000000     |     
            //   c705????????00ac4200     |     
            //   c705????????12ea4100     |     
            //   c705????????02000000     |     
            //   c605????????02       |                     

        $sequence_3 = { c605????????01 c705????????9fe14100 c705????????a8074200 c605????????01 c705????????a8e14100 c705????????c0074200 c705????????01000000 }
            // n = 7, score = 100
            //   c605????????01       |                     
            //   c705????????9fe14100     |     
            //   c705????????a8074200     |     
            //   c605????????01       |                     
            //   c705????????a8e14100     |     
            //   c705????????c0074200     |     
            //   c705????????01000000     |     

        $sequence_4 = { c705????????a0a44200 c705????????00d64100 c705????????a8004200 c705????????00000000 c705????????04000000 c705????????04000000 66c705????????1d03 }
            // n = 7, score = 100
            //   c705????????a0a44200     |     
            //   c705????????00d64100     |     
            //   c705????????a8004200     |     
            //   c705????????00000000     |     
            //   c705????????04000000     |     
            //   c705????????04000000     |     
            //   66c705????????1d03     |     

        $sequence_5 = { 8b55ec 0345e0 1355e4 83c424 5b 5e 5f }
            // n = 7, score = 100
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   0345e0               | add                 eax, dword ptr [ebp - 0x20]
            //   1355e4               | adc                 edx, dword ptr [ebp - 0x1c]
            //   83c424               | add                 esp, 0x24
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi

        $sequence_6 = { 8b4de4 89c2 e8???????? 52 8b0e 89c3 }
            // n = 6, score = 100
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   89c2                 | mov                 edx, eax
            //   e8????????           |                     
            //   52                   | push                edx
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   89c3                 | mov                 ebx, eax

        $sequence_7 = { c605????????01 c705????????04000000 c705????????e08c4200 c705????????93ea4100 c705????????20134200 c605????????01 c705????????08000000 }
            // n = 7, score = 100
            //   c605????????01       |                     
            //   c705????????04000000     |     
            //   c705????????e08c4200     |     
            //   c705????????93ea4100     |     
            //   c705????????20134200     |     
            //   c605????????01       |                     
            //   c705????????08000000     |     

        $sequence_8 = { c705????????c0ac4200 c705????????8cea4100 c705????????08134200 c605????????01 c705????????04000000 c705????????e08c4200 c705????????93ea4100 }
            // n = 7, score = 100
            //   c705????????c0ac4200     |     
            //   c705????????8cea4100     |     
            //   c705????????08134200     |     
            //   c605????????01       |                     
            //   c705????????04000000     |     
            //   c705????????e08c4200     |     
            //   c705????????93ea4100     |     

        $sequence_9 = { 720d 48 891c24 89442404 e8???????? 8b470c 8b55d4 }
            // n = 7, score = 100
            //   720d                 | jb                  0xf
            //   48                   | dec                 eax
            //   891c24               | mov                 dword ptr [esp], ebx
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   e8????????           |                     
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]

    condition:
        7 of them and filesize < 919552
}