rule win_unidentified_100_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_100."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_100"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f8ff 751e 488d8c2490020000 ff15???????? 4889442430 488b4c2430 ff15???????? }
            // n = 7, score = 200
            //   83f8ff               | mov                 edx, 0x12c
            //   751e                 | dec                 eax
            //   488d8c2490020000     | lea                 ecx, [esp + 0xac0]
            //   ff15????????         |                     
            //   4889442430           | mov                 ecx, 0x2e
            //   488b4c2430           | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   ff15????????         |                     

        $sequence_1 = { 4833c4 4889442428 488d442450 4889442420 4c8b4c2420 4c8b442448 baf4010000 }
            // n = 7, score = 200
            //   4833c4               | mov                 ecx, 0x92
            //   4889442428           | rep stosb           byte ptr es:[edi], al
            //   488d442450           | dec                 eax
            //   4889442420           | lea                 eax, [esp + 0x140]
            //   4c8b4c2420           | dec                 eax
            //   4c8b442448           | lea                 ecx, [0x1f8e0]
            //   baf4010000           | dec                 eax

        $sequence_2 = { 48ffc1 eb0f 0fb601 4a0fbe842830730200 4803c8 48ffc7 48ffc1 }
            // n = 7, score = 200
            //   48ffc1               | inc                 edx
            //   eb0f                 | test                byte ptr [ecx + ebp*8 + 0x38], 4
            //   0fb601               | je                  0xf18
            //   4a0fbe842830730200     | dec    esi
            //   4803c8               | add                 dword ptr [eax], eax
            //   48ffc7               | dec                 eax
            //   48ffc1               | mov                 ecx, dword ptr [ebx]

        $sequence_3 = { 488b4c2470 c6040104 e9???????? 48630424 488b4c2478 0fb60401 }
            // n = 6, score = 200
            //   488b4c2470           | jne                 0x47c
            //   c6040104             | dec                 eax
            //   e9????????           |                     
            //   48630424             | mov                 eax, dword ptr [ebp + 0x30]
            //   488b4c2478           | dec                 eax
            //   0fb60401             | mov                 ecx, dword ptr [eax + 0x88]

        $sequence_4 = { 448b4c2440 4c8d05e7e00100 ba14000000 488d8c2430030000 e8???????? 488d842448030000 4889442428 }
            // n = 7, score = 200
            //   448b4c2440           | dec                 esp
            //   4c8d05e7e00100       | lea                 eax, [0x13dbf]
            //   ba14000000           | dec                 eax
            //   488d8c2430030000     | mov                 ebp, eax
            //   e8????????           |                     
            //   488d842448030000     | dec                 esp
            //   4889442428           | lea                 edi, [ecx + ecx*8]

        $sequence_5 = { e8???????? 4533c9 4c8d8424e0040000 488d942490090000 33c9 e8???????? 33c0 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   4533c9               | xor                 edx, edx
            //   4c8d8424e0040000     | dec                 ecx
            //   488d942490090000     | mov                 ecx, edi
            //   33c9                 | inc                 ecx
            //   e8????????           |                     
            //   33c0                 | mov                 eax, 0x800

        $sequence_6 = { 8b4c2454 e8???????? 8b442460 89442464 8b542464 488d8c24e0020000 }
            // n = 6, score = 200
            //   8b4c2454             | jge                 0x23a
            //   e8????????           |                     
            //   8b442460             | movzx               eax, byte ptr [esp + 0x20]
            //   89442464             | lea                 eax, [eax*4 - 4]
            //   8b542464             | dec                 eax
            //   488d8c24e0020000     | cwde                

        $sequence_7 = { 8b0d???????? 488bd8 33d2 e8???????? 4885db 7414 488d052a090200 }
            // n = 7, score = 200
            //   8b0d????????         |                     
            //   488bd8               | dec                 eax
            //   33d2                 | mov                 edi, eax
            //   e8????????           |                     
            //   4885db               | dec                 eax
            //   7414                 | mov                 esi, ecx
            //   488d052a090200       | mov                 ecx, 0x16

        $sequence_8 = { b901000000 486bc902 488b542418 88040a b801000000 486bc003 }
            // n = 6, score = 200
            //   b901000000           | dec                 eax
            //   486bc902             | lea                 edx, [0x1e2ac]
            //   488b542418           | inc                 ecx
            //   88040a               | mov                 eax, 0xff
            //   b801000000           | dec                 eax
            //   486bc003             | lea                 edx, [esp + 0x1b0]

        $sequence_9 = { e8???????? 488b8c2430010000 e8???????? 89442448 4883bc243001000000 740d }
            // n = 6, score = 200
            //   e8????????           |                     
            //   488b8c2430010000     | dec                 eax
            //   e8????????           |                     
            //   89442448             | arpl                word ptr [esp], ax
            //   4883bc243001000000     | dec    eax
            //   740d                 | arpl                word ptr [esp], ax

    condition:
        7 of them and filesize < 372736
}