rule win_unidentified_104_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_104."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_104"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7607 ff15???????? cc e8???????? 0f117570 }
            // n = 5, score = 100
            //   7607                 | dec                 eax
            //   ff15????????         |                     
            //   cc                   | shl                 ecx, 0x10
            //   e8????????           |                     
            //   0f117570             | dec                 eax

        $sequence_1 = { 4c33df 498bcb 49c1eb18 48c1e128 4933cb 4c8b9c2490000000 }
            // n = 6, score = 100
            //   4c33df               | dec                 ecx
            //   498bcb               | mov                 esi, eax
            //   49c1eb18             | dec                 eax
            //   48c1e128             | shr                 edx, 1
            //   4933cb               | dec                 ecx
            //   4c8b9c2490000000     | mov                 eax, edx

        $sequence_2 = { 0f1030 0f107810 4c896810 48c740180f000000 448828 488b9588000000 483bd3 }
            // n = 7, score = 100
            //   0f1030               | jne                 0x1ff
            //   0f107810             | dec                 eax
            //   4c896810             | lea                 eax, [0x5d5]
            //   48c740180f000000     | jne                 0x208
            //   448828               | dec                 eax
            //   488b9588000000       | lea                 eax, [0x760]
            //   483bd3               | cmp                 eax, 0x56f4aa9

        $sequence_3 = { 0f2975a7 448b4d6f 4c8bc6 488d55e7 488d4d97 e8???????? 83f801 }
            // n = 7, score = 100
            //   0f2975a7             | dec                 esp
            //   448b4d6f             | mov                 dword ptr [ebp + 0x38], edi
            //   4c8bc6               | inc                 esp
            //   488d55e7             | mov                 byte ptr [ebp + 0x20], dh
            //   488d4d97             | movups              xmm0, xmmword ptr [ebx]
            //   e8????????           |                     
            //   83f801               | ja                  0x35d

        $sequence_4 = { 488d4d88 e8???????? 488d158f550100 488d4d88 e8???????? cc }
            // n = 6, score = 100
            //   488d4d88             | mov                 eax, ebx
            //   e8????????           |                     
            //   488d158f550100       | dec                 eax
            //   488d4d88             | lea                 edx, [esp + 0x20]
            //   e8????????           |                     
            //   cc                   | inc                 esp

        $sequence_5 = { 4183fd04 7d22 b804000000 488d4d48 412bc5 33d2 4c63c0 }
            // n = 7, score = 100
            //   4183fd04             | dec                 eax
            //   7d22                 | lea                 ecx, [0x13848]
            //   b804000000           | dec                 eax
            //   488d4d48             | mov                 ecx, eax
            //   412bc5               | dec                 eax
            //   33d2                 | lea                 edx, [esp + 0x20]
            //   4c63c0               | mov                 dword ptr [esp + 0x30], 1

        $sequence_6 = { 0f107507 0f2975a7 488d4d97 e8???????? 48b884afc053ee926aaf 488945e7 48b9a4ee4415aba19f06 }
            // n = 7, score = 100
            //   0f107507             | dec                 esp
            //   0f2975a7             | mov                 dword ptr [ebp + 0xb0], esp
            //   488d4d97             | dec                 esp
            //   e8????????           |                     
            //   48b884afc053ee926aaf     | mov    dword ptr [ebp + 0xb8], ebp
            //   488945e7             | jne                 0x4c0
            //   48b9a4ee4415aba19f06     | dec    eax

        $sequence_7 = { e8???????? 448b0b 4533c0 4585c9 0f84be000000 4c8d15b4b4ffff 488b4318 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   448b0b               | jg                  0x733
            //   4533c0               | dec                 eax
            //   4585c9               | mov                 ecx, dword ptr [ecx + 8]
            //   0f84be000000         | mov                 eax, edx
            //   4c8d15b4b4ffff       | shr                 eax, 0x18
            //   488b4318             | mov                 byte ptr [esp + 0x10], al

        $sequence_8 = { 488d3c10 4d8bc4 488bcf 33d2 e8???????? 46883427 eb0e }
            // n = 7, score = 100
            //   488d3c10             | dec                 eax
            //   4d8bc4               | mov                 edx, dword ptr [edi + 0x50]
            //   488bcf               | dec                 eax
            //   33d2                 | cmp                 edx, 0x10
            //   e8????????           |                     
            //   46883427             | jb                  0x207
            //   eb0e                 | dec                 eax

        $sequence_9 = { 488d5304 448bc6 488bcf e8???????? 488d5308 448bc6 488bcf }
            // n = 7, score = 100
            //   488d5304             | lea                 ecx, [edx + 0x2000000]
            //   448bc6               | dec                 eax
            //   488bcf               | sar                 ecx, 0x1a
            //   e8????????           |                     
            //   488d5308             | dec                 eax
            //   448bc6               | mov                 eax, ecx
            //   488bcf               | dec                 eax

    condition:
        7 of them and filesize < 263168
}