rule win_unidentified_110_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_110."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_110"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8d05f8f80f00 e8???????? 4889c1 488d542460 e8???????? 84c0 0f850a010000 }
            // n = 7, score = 100
            //   4c8d05f8f80f00       | jbe                 0x80a
            //   e8????????           |                     
            //   4889c1               | inc                 ecx
            //   488d542460           | cmp                 esi, eax
            //   e8????????           |                     
            //   84c0                 | dec                 eax
            //   0f850a010000         | mov                 ecx, dword ptr [esp + 0x30]

        $sequence_1 = { 7405 b801000000 4883c428 c3 4883ec48 488d0595590d00 4889442430 }
            // n = 7, score = 100
            //   7405                 | dec                 eax
            //   b801000000           | mov                 esi, ecx
            //   4883c428             | movzx               eax, byte ptr [edx]
            //   c3                   | dec                 eax
            //   4883ec48             | cmp                 eax, 3
            //   488d0595590d00       | push                edi
            //   4889442430           | push                ebx

        $sequence_2 = { eb0d 4c8d055c100f00 4889f1 4c89fa e8???????? 0f0b 4c8d0560100f00 }
            // n = 7, score = 100
            //   eb0d                 | dec                 esp
            //   4c8d055c100f00       | mov                 ecx, ebp
            //   4889f1               | dec                 eax
            //   4c89fa               | lea                 ecx, [0x53fce]
            //   e8????????           |                     
            //   0f0b                 | dec                 esp
            //   4c8d0560100f00       | lea                 eax, [0x540df]

        $sequence_3 = { 48898c2440050000 0fb7842496070000 4889842448050000 48c1e020 4809c8 4889842438050000 8b842498070000 }
            // n = 7, score = 100
            //   48898c2440050000     | dec                 ebp
            //   0fb7842496070000     | mov                 eax, esp
            //   4889842448050000     | dec                 ecx
            //   48c1e020             | mov                 ecx, ebp
            //   4809c8               | dec                 eax
            //   4889842438050000     | mov                 dword ptr [esp + 0x38], edx
            //   8b842498070000       | dec                 eax

        $sequence_4 = { 8b8424b0020000 898424bc020000 8b8424a0020000 898424ac020000 8b8424a4020000 898424b0020000 8b84248c020000 }
            // n = 7, score = 100
            //   8b8424b0020000       | dec                 eax
            //   898424bc020000       | mov                 dword ptr [esp + 0x628], eax
            //   8b8424a0020000       | mov                 eax, dword ptr [esp + 0x274]
            //   898424ac020000       | mov                 eax, dword ptr [esp + 0x47c]
            //   8b8424a4020000       | mov                 dword ptr [ebx + 0x138], eax
            //   898424b0020000       | mov                 eax, dword ptr [esp + 0x480]
            //   8b84248c020000       | mov                 dword ptr [ebx + 0x13c], eax

        $sequence_5 = { 498d7c2401 488b7500 488b4e40 41b601 b800000000 4885c9 759a }
            // n = 7, score = 100
            //   498d7c2401           | dec                 esp
            //   488b7500             | mov                 eax, edx
            //   488b4e40             | dec                 eax
            //   41b601               | sbb                 eax, edi
            //   b800000000           | dec                 eax
            //   4885c9               | mul                 edi
            //   759a                 | mov                 ecx, ecx

        $sequence_6 = { 48d3ee 4489f9 e8???????? 21f0 418906 428d043b 894708 }
            // n = 7, score = 100
            //   48d3ee               | mov                 dword ptr [esp + 0x180], eax
            //   4489f9               | dec                 eax
            //   e8????????           |                     
            //   21f0                 | add                 edx, 8
            //   418906               | dec                 eax
            //   428d043b             | lea                 ecx, [esp + 0x4a0]
            //   894708               | dec                 esp

        $sequence_7 = { f049834e4001 4883a4242802000000 498d7618 4889f1 e8???????? 4d8b7e10 41f6c701 }
            // n = 7, score = 100
            //   f049834e4001         | dec                 eax
            //   4883a4242802000000     | and    ebp, eax
            //   498d7618             | jmp                 0x9a
            //   4889f1               | dec                 eax
            //   e8????????           |                     
            //   4d8b7e10             | mov                 edx, dword ptr [ebp + 0x1238]
            //   41f6c701             | dec                 eax

        $sequence_8 = { 492b442410 48ffcd 4821c5 31ff 4c8d35382d0f00 488b5c2478 4839fd }
            // n = 7, score = 100
            //   492b442410           | dec                 eax
            //   48ffcd               | add                 esp, 0x78
            //   4821c5               | pop                 ebx
            //   31ff                 | dec                 eax
            //   4c8d35382d0f00       | lea                 ecx, [ebp + 0x520]
            //   488b5c2478           | mov                 byte ptr [ebp + 0x5d2], 1
            //   4839fd               | movdqa              xmm6, xmmword ptr [esp + 0x60]

        $sequence_9 = { ba04000000 e8???????? 832000 66c740040200 6644897806 896808 4883600c00 }
            // n = 7, score = 100
            //   ba04000000           | mov                 dword ptr [esi + 0x10], esi
            //   e8????????           |                     
            //   832000               | mov                 word ptr [esi + 0x18], ax
            //   66c740040200         | xor                 eax, eax
            //   6644897806           | mov                 ecx, 0x3bcfbbf
            //   896808               | bt                  ecx, eax
            //   4883600c00           | jae                 0x6c8

    condition:
        7 of them and filesize < 3217408
}