rule win_urlzone_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.urlzone."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.urlzone"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7503 8a0a 42 80e930 80f909 7708 }
            // n = 6, score = 3000
            //   7503                 | jne                 5
            //   8a0a                 | mov                 cl, byte ptr [edx]
            //   42                   | inc                 edx
            //   80e930               | sub                 cl, 0x30
            //   80f909               | cmp                 cl, 9
            //   7708                 | ja                  0xa

        $sequence_1 = { 7c42 80f866 7f3d 80ec61 }
            // n = 4, score = 3000
            //   7c42                 | jl                  0x44
            //   80f866               | cmp                 al, 0x66
            //   7f3d                 | jg                  0x3f
            //   80ec61               | sub                 ah, 0x61

        $sequence_2 = { 7f08 80ec41 80c40a eb10 }
            // n = 4, score = 3000
            //   7f08                 | jg                  0xa
            //   80ec41               | sub                 ah, 0x41
            //   80c40a               | add                 ah, 0xa
            //   eb10                 | jmp                 0x12

        $sequence_3 = { 80fc39 7f05 80ec30 eb22 }
            // n = 4, score = 3000
            //   80fc39               | cmp                 ah, 0x39
            //   7f05                 | jg                  7
            //   80ec30               | sub                 ah, 0x30
            //   eb22                 | jmp                 0x24

        $sequence_4 = { 80e830 eb22 80f841 7c23 80f846 7f08 }
            // n = 6, score = 3000
            //   80e830               | sub                 al, 0x30
            //   eb22                 | jmp                 0x24
            //   80f841               | cmp                 al, 0x41
            //   7c23                 | jl                  0x25
            //   80f846               | cmp                 al, 0x46
            //   7f08                 | jg                  0xa

        $sequence_5 = { 7f08 80ec41 80c40a eb10 80fc61 7c42 }
            // n = 6, score = 3000
            //   7f08                 | jg                  0xa
            //   80ec41               | sub                 ah, 0x41
            //   80c40a               | add                 ah, 0xa
            //   eb10                 | jmp                 0x12
            //   80fc61               | cmp                 ah, 0x61
            //   7c42                 | jl                  0x44

        $sequence_6 = { eb10 80f861 7c11 80f866 7f0c }
            // n = 5, score = 3000
            //   eb10                 | jmp                 0x12
            //   80f861               | cmp                 al, 0x61
            //   7c11                 | jl                  0x13
            //   80f866               | cmp                 al, 0x66
            //   7f0c                 | jg                  0xe

        $sequence_7 = { 80e930 80f909 7708 8d0480 8d0441 ebed }
            // n = 6, score = 3000
            //   80e930               | sub                 cl, 0x30
            //   80f909               | cmp                 cl, 9
            //   7708                 | ja                  0xa
            //   8d0480               | lea                 eax, [eax + eax*4]
            //   8d0441               | lea                 eax, [ecx + eax*2]
            //   ebed                 | jmp                 0xffffffef

        $sequence_8 = { 80ec61 80c40a 80f830 7c32 80f839 7f05 }
            // n = 6, score = 3000
            //   80ec61               | sub                 ah, 0x61
            //   80c40a               | add                 ah, 0xa
            //   80f830               | cmp                 al, 0x30
            //   7c32                 | jl                  0x34
            //   80f839               | cmp                 al, 0x39
            //   7f05                 | jg                  7

        $sequence_9 = { 7c63 80fc39 7f05 80ec30 eb22 80fc41 7c54 }
            // n = 7, score = 3000
            //   7c63                 | jl                  0x65
            //   80fc39               | cmp                 ah, 0x39
            //   7f05                 | jg                  7
            //   80ec30               | sub                 ah, 0x30
            //   eb22                 | jmp                 0x24
            //   80fc41               | cmp                 ah, 0x41
            //   7c54                 | jl                  0x56

    condition:
        7 of them and filesize < 704512
}