rule win_vegalocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vegalocker"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bcf e8???????? 8d45c0 33c9 ba20000000 e8???????? }
            // n = 6, score = 300
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8d45c0               | lea                 eax, [ebp - 0x40]
            //   33c9                 | xor                 ecx, ecx
            //   ba20000000           | mov                 edx, 0x20
            //   e8????????           |                     

        $sequence_1 = { e8???????? 83fb10 7f25 b800010000 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   83fb10               | cmp                 ebx, 0x10
            //   7f25                 | jg                  0x27
            //   b800010000           | mov                 eax, 0x100

        $sequence_2 = { 8d55e0 b908000000 8bc3 e8???????? }
            // n = 4, score = 300
            //   8d55e0               | lea                 edx, [ebp - 0x20]
            //   b908000000           | mov                 ecx, 8
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     

        $sequence_3 = { 8d45fc e8???????? 83fb10 7f25 }
            // n = 4, score = 300
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   e8????????           |                     
            //   83fb10               | cmp                 ebx, 0x10
            //   7f25                 | jg                  0x27

        $sequence_4 = { 8b40f4 83c00c e8???????? 8bd0 8b4508 }
            // n = 5, score = 300
            //   8b40f4               | mov                 eax, dword ptr [eax - 0xc]
            //   83c00c               | add                 eax, 0xc
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_5 = { 83ee04 8b36 8d45f0 e8???????? 8bd0 8bce 8bc3 }
            // n = 7, score = 300
            //   83ee04               | sub                 esi, 4
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   8bce                 | mov                 ecx, esi
            //   8bc3                 | mov                 eax, ebx

        $sequence_6 = { 33d2 8b45f0 8b08 ff5118 }
            // n = 4, score = 300
            //   33d2                 | xor                 edx, edx
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5118               | call                dword ptr [ecx + 0x18]

        $sequence_7 = { 8b48f8 8b4508 8b50fc 8d45f4 e8???????? 8b45f4 }
            // n = 6, score = 300
            //   8b48f8               | mov                 ecx, dword ptr [eax - 8]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b50fc               | mov                 edx, dword ptr [eax - 4]
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   e8????????           |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_8 = { 6a20 8b45e8 e8???????? 50 e8???????? }
            // n = 5, score = 300
            //   6a20                 | push                0x20
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_9 = { 8b40f4 83c00c e8???????? 8bd0 }
            // n = 4, score = 300
            //   8b40f4               | mov                 eax, dword ptr [eax - 0xc]
            //   83c00c               | add                 eax, 0xc
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax

    condition:
        7 of them and filesize < 1654784
}