rule win_velso_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.velso."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.velso"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83ec04 85c0 754d 8b45e0 8d55e8 39d0 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83ec04               | sub                 esp, 4
            //   85c0                 | test                eax, eax
            //   754d                 | jne                 0x4f
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8d55e8               | lea                 edx, [ebp - 0x18]
            //   39d0                 | cmp                 eax, edx

        $sequence_1 = { e8???????? 8d45d0 8d4dc8 8945c8 8b450c 89442404 8b4508 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_2 = { 01da 01d8 83ed01 83fdff 744c 0fb65c2407 8b742428 }
            // n = 7, score = 200
            //   01da                 | add                 edx, ebx
            //   01d8                 | add                 eax, ebx
            //   83ed01               | sub                 ebp, 1
            //   83fdff               | cmp                 ebp, -1
            //   744c                 | je                  0x4e
            //   0fb65c2407           | movzx               ebx, byte ptr [esp + 7]
            //   8b742428             | mov                 esi, dword ptr [esp + 0x28]

        $sequence_3 = { e8???????? 8b4508 895804 8b80b0000000 85c0 0f85cd000000 8b4508 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   895804               | mov                 dword ptr [eax + 4], ebx
            //   8b80b0000000         | mov                 eax, dword ptr [eax + 0xb0]
            //   85c0                 | test                eax, eax
            //   0f85cd000000         | jne                 0xd3
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_4 = { 8d742600 8b4d10 85c9 0f840cfeffff 0fb6458d 8845a0 31c0 }
            // n = 7, score = 200
            //   8d742600             | lea                 esi, [esi]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   85c9                 | test                ecx, ecx
            //   0f840cfeffff         | je                  0xfffffe12
            //   0fb6458d             | movzx               eax, byte ptr [ebp - 0x73]
            //   8845a0               | mov                 byte ptr [ebp - 0x60], al
            //   31c0                 | xor                 eax, eax

        $sequence_5 = { ebb5 e8???????? 89f6 8dbc2700000000 83ec0c e8???????? 8b4004 }
            // n = 7, score = 200
            //   ebb5                 | jmp                 0xffffffb7
            //   e8????????           |                     
            //   89f6                 | mov                 esi, esi
            //   8dbc2700000000       | lea                 edi, [edi]
            //   83ec0c               | sub                 esp, 0xc
            //   e8????????           |                     
            //   8b4004               | mov                 eax, dword ptr [eax + 4]

        $sequence_6 = { 8bbc24c4000000 899424c0000000 e9???????? 8b8c24f8000000 29da 89542430 c78424b400000001000000 }
            // n = 7, score = 200
            //   8bbc24c4000000       | mov                 edi, dword ptr [esp + 0xc4]
            //   899424c0000000       | mov                 dword ptr [esp + 0xc0], edx
            //   e9????????           |                     
            //   8b8c24f8000000       | mov                 ecx, dword ptr [esp + 0xf8]
            //   29da                 | sub                 edx, ebx
            //   89542430             | mov                 dword ptr [esp + 0x30], edx
            //   c78424b400000001000000     | mov    dword ptr [esp + 0xb4], 1

        $sequence_7 = { 8b8424a4000000 830802 89d8 66896c2448 89de 89442458 8b7c243c }
            // n = 7, score = 200
            //   8b8424a4000000       | mov                 eax, dword ptr [esp + 0xa4]
            //   830802               | or                  dword ptr [eax], 2
            //   89d8                 | mov                 eax, ebx
            //   66896c2448           | mov                 word ptr [esp + 0x48], bp
            //   89de                 | mov                 esi, ebx
            //   89442458             | mov                 dword ptr [esp + 0x58], eax
            //   8b7c243c             | mov                 edi, dword ptr [esp + 0x3c]

        $sequence_8 = { 890424 e8???????? 84c0 0f8451070000 8b4d84 85c9 0f94c0 }
            // n = 7, score = 200
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f8451070000         | je                  0x757
            //   8b4d84               | mov                 ecx, dword ptr [ebp - 0x7c]
            //   85c9                 | test                ecx, ecx
            //   0f94c0               | sete                al

        $sequence_9 = { 8b9424c0000000 8344243401 8954243c 8b7c2450 85ff 0f84fe0f0000 035c2434 }
            // n = 7, score = 200
            //   8b9424c0000000       | mov                 edx, dword ptr [esp + 0xc0]
            //   8344243401           | add                 dword ptr [esp + 0x34], 1
            //   8954243c             | mov                 dword ptr [esp + 0x3c], edx
            //   8b7c2450             | mov                 edi, dword ptr [esp + 0x50]
            //   85ff                 | test                edi, edi
            //   0f84fe0f0000         | je                  0x1004
            //   035c2434             | add                 ebx, dword ptr [esp + 0x34]

    condition:
        7 of them and filesize < 1736704
}