rule win_vendetta_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.vendetta."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.vendetta"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b04c5e06f4100 5d c3 33c0 5d }
            // n = 5, score = 100
            //   8b04c5e06f4100       | mov                 eax, dword ptr [eax*8 + 0x416fe0]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   5d                   | pop                 ebp

        $sequence_1 = { 83c408 84c0 0f845d010000 6a00 51 0bf9 }
            // n = 6, score = 100
            //   83c408               | add                 esp, 8
            //   84c0                 | test                al, al
            //   0f845d010000         | je                  0x163
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   0bf9                 | or                  edi, ecx

        $sequence_2 = { 660f2815???????? f20f59db 660f282d???????? 660f59f5 660f28aa30914100 }
            // n = 5, score = 100
            //   660f2815????????     |                     
            //   f20f59db             | mulsd               xmm3, xmm3
            //   660f282d????????     |                     
            //   660f59f5             | mulpd               xmm6, xmm5
            //   660f28aa30914100     | movapd              xmm5, xmmword ptr [edx + 0x419130]

        $sequence_3 = { 83a500fcffff00 51 8d8df8fbffff e8???????? 898500fcffff }
            // n = 5, score = 100
            //   83a500fcffff00       | and                 dword ptr [ebp - 0x400], 0
            //   51                   | push                ecx
            //   8d8df8fbffff         | lea                 ecx, [ebp - 0x408]
            //   e8????????           |                     
            //   898500fcffff         | mov                 dword ptr [ebp - 0x400], eax

        $sequence_4 = { 8b4508 dd00 ebc6 c745e0d8924100 e9???????? c745e0e0924100 }
            // n = 6, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   dd00                 | fld                 qword ptr [eax]
            //   ebc6                 | jmp                 0xffffffc8
            //   c745e0d8924100       | mov                 dword ptr [ebp - 0x20], 0x4192d8
            //   e9????????           |                     
            //   c745e0e0924100       | mov                 dword ptr [ebp - 0x20], 0x4192e0

        $sequence_5 = { 6a30 eb27 3bcb 7f0e 7c08 81fa0000800c 7704 }
            // n = 7, score = 100
            //   6a30                 | push                0x30
            //   eb27                 | jmp                 0x29
            //   3bcb                 | cmp                 ecx, ebx
            //   7f0e                 | jg                  0x10
            //   7c08                 | jl                  0xa
            //   81fa0000800c         | cmp                 edx, 0xc800000
            //   7704                 | ja                  6

        $sequence_6 = { 7309 8b04c5e06f4100 5d c3 33c0 5d c3 }
            // n = 7, score = 100
            //   7309                 | jae                 0xb
            //   8b04c5e06f4100       | mov                 eax, dword ptr [eax*8 + 0x416fe0]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_7 = { 85c0 7433 8bce e8???????? 8bf8 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   7433                 | je                  0x35
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_8 = { 33c9 8bc1 3914c5b89b4100 7408 40 83f81d 7cf1 }
            // n = 7, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   8bc1                 | mov                 eax, ecx
            //   3914c5b89b4100       | cmp                 dword ptr [eax*8 + 0x419bb8], edx
            //   7408                 | je                  0xa
            //   40                   | inc                 eax
            //   83f81d               | cmp                 eax, 0x1d
            //   7cf1                 | jl                  0xfffffff3

        $sequence_9 = { 53 8d85f0f7ffff 50 56 }
            // n = 4, score = 100
            //   53                   | push                ebx
            //   8d85f0f7ffff         | lea                 eax, [ebp - 0x810]
            //   50                   | push                eax
            //   56                   | push                esi

    condition:
        7 of them and filesize < 296960
}