rule win_virlock_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.virlock."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.virlock"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81f234ea98fc ba77fa04fa bb5191b6fe e8???????? 81f2fcfd84fd bb9d77e800 81f32dcee8ff }
            // n = 7, score = 100
            //   81f234ea98fc         | xor                 edx, 0xfc98ea34
            //   ba77fa04fa           | mov                 edx, 0xfa04fa77
            //   bb5191b6fe           | mov                 ebx, 0xfeb69151
            //   e8????????           |                     
            //   81f2fcfd84fd         | xor                 edx, 0xfd84fdfc
            //   bb9d77e800           | mov                 ebx, 0xe8779d
            //   81f32dcee8ff         | xor                 ebx, 0xffe8ce2d

        $sequence_1 = { 41 4a 54 52 4a 4b 55 }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   4a                   | dec                 edx
            //   54                   | push                esp
            //   52                   | push                edx
            //   4a                   | dec                 edx
            //   4b                   | dec                 ebx
            //   55                   | push                ebp

        $sequence_2 = { 68???????? eb0a 68???????? 68???????? e8???????? 83fa00 751b }
            // n = 7, score = 100
            //   68????????           |                     
            //   eb0a                 | jmp                 0xc
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83fa00               | cmp                 edx, 0
            //   751b                 | jne                 0x1d

        $sequence_3 = { 49 52 43 52 58 }
            // n = 5, score = 100
            //   49                   | dec                 ecx
            //   52                   | push                edx
            //   43                   | inc                 ebx
            //   52                   | push                edx
            //   58                   | pop                 eax

        $sequence_4 = { 3b12 3646 9a19386f50123e 54 0ae7 0220 6f }
            // n = 7, score = 100
            //   3b12                 | cmp                 edx, dword ptr [edx]
            //   3646                 | inc                 esi
            //   9a19386f50123e       | lcall               0x3e12:0x506f3819
            //   54                   | push                esp
            //   0ae7                 | or                  ah, bh
            //   0220                 | add                 ah, byte ptr [eax]
            //   6f                   | outsd               dx, dword ptr [esi]

        $sequence_5 = { d0c3 4a 43 d0a90a2bd0f3 }
            // n = 4, score = 100
            //   d0c3                 | rol                 bl, 1
            //   4a                   | dec                 edx
            //   43                   | inc                 ebx
            //   d0a90a2bd0f3         | shr                 byte ptr [ecx - 0xc2fd4f6], 1

        $sequence_6 = { bb666d87fd 83e904 ba0dd2b2fe eb00 83f905 7d74 bb93ec7eff }
            // n = 7, score = 100
            //   bb666d87fd           | mov                 ebx, 0xfd876d66
            //   83e904               | sub                 ecx, 4
            //   ba0dd2b2fe           | mov                 edx, 0xfeb2d20d
            //   eb00                 | jmp                 2
            //   83f905               | cmp                 ecx, 5
            //   7d74                 | jge                 0x76
            //   bb93ec7eff           | mov                 ebx, 0xff7eec93

        $sequence_7 = { 6b484768 e4cc 681cafc880 cf 6a78 d6 49 }
            // n = 7, score = 100
            //   6b484768             | imul                ecx, dword ptr [eax + 0x47], 0x68
            //   e4cc                 | in                  al, 0xcc
            //   681cafc880           | push                0x80c8af1c
            //   cf                   | iretd               
            //   6a78                 | push                0x78
            //   d6                   | salc                
            //   49                   | dec                 ecx

        $sequence_8 = { 70c1 8a6a8f b3f0 46 fd 098f46182e59 53 }
            // n = 7, score = 100
            //   70c1                 | jo                  0xffffffc3
            //   8a6a8f               | mov                 ch, byte ptr [edx - 0x71]
            //   b3f0                 | mov                 bl, 0xf0
            //   46                   | inc                 esi
            //   fd                   | std                 
            //   098f46182e59         | or                  dword ptr [edi + 0x592e1846], ecx
            //   53                   | push                ebx

        $sequence_9 = { 36a25c6a5eac 42 775c 44 e4f2 2b470c d04ba2 }
            // n = 7, score = 100
            //   36a25c6a5eac         | mov                 byte ptr ss:[0xac5e6a5c], al
            //   42                   | inc                 edx
            //   775c                 | ja                  0x5e
            //   44                   | inc                 esp
            //   e4f2                 | in                  al, 0xf2
            //   2b470c               | sub                 eax, dword ptr [edi + 0xc]
            //   d04ba2               | ror                 byte ptr [ebx - 0x5e], 1

    condition:
        7 of them and filesize < 4202496
}