rule win_wallyshack_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wallyshack"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 89049d68474600 be01000000 33c0 5a }
            // n = 5, score = 100
            //   e8????????           |                     
            //   89049d68474600       | mov                 dword ptr [ebx*4 + 0x464768], eax
            //   be01000000           | mov                 esi, 1
            //   33c0                 | xor                 eax, eax
            //   5a                   | pop                 edx

        $sequence_1 = { 83f802 7415 6a00 b102 b201 a1???????? }
            // n = 6, score = 100
            //   83f802               | cmp                 eax, 2
            //   7415                 | je                  0x17
            //   6a00                 | push                0
            //   b102                 | mov                 cl, 2
            //   b201                 | mov                 dl, 1
            //   a1????????           |                     

        $sequence_2 = { 8955fc 8bf0 6683be9a00000000 7415 8b4508 }
            // n = 5, score = 100
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   8bf0                 | mov                 esi, eax
            //   6683be9a00000000     | cmp                 word ptr [esi + 0x9a], 0
            //   7415                 | je                  0x17
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_3 = { def9 eb0e ddd8 dbabb1324000 }
            // n = 4, score = 100
            //   def9                 | fdivp               st(1)
            //   eb0e                 | jmp                 0x10
            //   ddd8                 | fstp                st(0)
            //   dbabb1324000         | fld                 xword ptr [ebx + 0x4032b1]

        $sequence_4 = { 8b45c8 e8???????? 8b852cffffff 8d55cc e8???????? 8b55cc b8???????? }
            // n = 7, score = 100
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   e8????????           |                     
            //   8b852cffffff         | mov                 eax, dword ptr [ebp - 0xd4]
            //   8d55cc               | lea                 edx, [ebp - 0x34]
            //   e8????????           |                     
            //   8b55cc               | mov                 edx, dword ptr [ebp - 0x34]
            //   b8????????           |                     

        $sequence_5 = { 83fb06 7f09 3b34dd20024600 75f1 83fb06 7f15 8b0cdd24024600 }
            // n = 7, score = 100
            //   83fb06               | cmp                 ebx, 6
            //   7f09                 | jg                  0xb
            //   3b34dd20024600       | cmp                 esi, dword ptr [ebx*8 + 0x460220]
            //   75f1                 | jne                 0xfffffff3
            //   83fb06               | cmp                 ebx, 6
            //   7f15                 | jg                  0x17
            //   8b0cdd24024600       | mov                 ecx, dword ptr [ebx*8 + 0x460224]

        $sequence_6 = { 0f8583000000 8b55f0 b8???????? e8???????? 85c0 7e72 }
            // n = 6, score = 100
            //   0f8583000000         | jne                 0x89
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   b8????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7e72                 | jle                 0x74

        $sequence_7 = { 0b0495640a4600 8b55fc 0fb692a5010000 0b0495740a4600 0d00200000 }
            // n = 5, score = 100
            //   0b0495640a4600       | or                  eax, dword ptr [edx*4 + 0x460a64]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   0fb692a5010000       | movzx               edx, byte ptr [edx + 0x1a5]
            //   0b0495740a4600       | or                  eax, dword ptr [edx*4 + 0x460a74]
            //   0d00200000           | or                  eax, 0x2000

        $sequence_8 = { 8bc3 e8???????? 8b45fc e8???????? f645f508 7462 c645cb20 }
            // n = 7, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   f645f508             | test                byte ptr [ebp - 0xb], 8
            //   7462                 | je                  0x64
            //   c645cb20             | mov                 byte ptr [ebp - 0x35], 0x20

        $sequence_9 = { 8b45fc c780b800000000000000 c780bc00000000000000 8b45fc c780d000000000000000 c780d400000000000000 }
            // n = 6, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c780b800000000000000     | mov    dword ptr [eax + 0xb8], 0
            //   c780bc00000000000000     | mov    dword ptr [eax + 0xbc], 0
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c780d000000000000000     | mov    dword ptr [eax + 0xd0], 0
            //   c780d400000000000000     | mov    dword ptr [eax + 0xd4], 0

    condition:
        7 of them and filesize < 1097728
}