rule win_webc2_qbp_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.webc2_qbp."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_qbp"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c20400 55 8bec 83ec08 894df8 8b4508 25ffff0000 }
            // n = 7, score = 100
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   25ffff0000           | and                 eax, 0xffff

        $sequence_1 = { 51 8b4de4 e8???????? eb2b 8b55e4 0fbf8246100000 05fd000000 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   eb2b                 | jmp                 0x2d
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   0fbf8246100000       | movsx               eax, word ptr [edx + 0x1046]
            //   05fd000000           | add                 eax, 0xfd

        $sequence_2 = { 66898c504c520000 0fbf5508 0fbf45fc 8b4df8 8b75f8 668b945648100000 6689944148100000 }
            // n = 7, score = 100
            //   66898c504c520000     | mov                 word ptr [eax + edx*2 + 0x524c], cx
            //   0fbf5508             | movsx               edx, word ptr [ebp + 8]
            //   0fbf45fc             | movsx               eax, word ptr [ebp - 4]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   668b945648100000     | mov                 dx, word ptr [esi + edx*2 + 0x1048]
            //   6689944148100000     | mov                 word ptr [ecx + eax*2 + 0x1048], dx

        $sequence_3 = { eb2b 8b55e4 0fbf8246100000 05fd000000 50 8b4de4 }
            // n = 6, score = 100
            //   eb2b                 | jmp                 0x2d
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   0fbf8246100000       | movsx               eax, word ptr [edx + 0x1046]
            //   05fd000000           | add                 eax, 0xfd
            //   50                   | push                eax
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]

        $sequence_4 = { 83c001 50 8b8d486cffff 51 }
            // n = 4, score = 100
            //   83c001               | add                 eax, 1
            //   50                   | push                eax
            //   8b8d486cffff         | mov                 ecx, dword ptr [ebp - 0x93b8]
            //   51                   | push                ecx

        $sequence_5 = { 83bdf46affff00 7504 33c0 eb57 8b85f46affff }
            // n = 5, score = 100
            //   83bdf46affff00       | cmp                 dword ptr [ebp - 0x950c], 0
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax
            //   eb57                 | jmp                 0x59
            //   8b85f46affff         | mov                 eax, dword ptr [ebp - 0x950c]

        $sequence_6 = { 837d0800 740e 837d0c00 7408 8b45f4 }
            // n = 5, score = 100
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   740e                 | je                  0x10
            //   837d0c00             | cmp                 dword ptr [ebp + 0xc], 0
            //   7408                 | je                  0xa
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_7 = { 894df8 c745fc00000000 6a01 8d45fc 50 8b4df8 e8???????? }
            // n = 7, score = 100
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   6a01                 | push                1
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   e8????????           |                     

        $sequence_8 = { ff15???????? 8945e4 837de4ff 7511 8b4de8 51 ff15???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   837de4ff             | cmp                 dword ptr [ebp - 0x1c], -1
            //   7511                 | jne                 0x13
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_9 = { 8b95e8fdffff 52 e8???????? 83c404 8985f0feffff c745fc00000000 c685f8feffff00 }
            // n = 7, score = 100
            //   8b95e8fdffff         | mov                 edx, dword ptr [ebp - 0x218]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8985f0feffff         | mov                 dword ptr [ebp - 0x110], eax
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c685f8feffff00       | mov                 byte ptr [ebp - 0x108], 0

    condition:
        7 of them and filesize < 630784
}