rule win_wininetloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.wininetloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wininetloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48895c2408 57 4883ec20 488bda 488d05ccd10400 488901 488d5108 }
            // n = 7, score = 100
            //   48895c2408           | mov                 eax, edi
            //   57                   | sub                 eax, ebx
            //   4883ec20             | cmp                 eax, dword ptr [esi + 0x24]
            //   488bda               | jae                 0x80c
            //   488d05ccd10400       | nop                 word ptr [eax + eax]
            //   488901               | movzx               edx, bx
            //   488d5108             | jb                  0x8ea

        $sequence_1 = { 8b3b 0f1f00 33c0 4d8bce 85ff 7422 488b4b10 }
            // n = 7, score = 100
            //   8b3b                 | inc                 ecx
            //   0f1f00               | mov                 ecx, 2
            //   33c0                 | dec                 eax
            //   4d8bce               | lea                 edx, [0xaad7a]
            //   85ff                 | dec                 eax
            //   7422                 | lea                 ecx, [ebp - 0x79]
            //   488b4b10             | nop                 

        $sequence_2 = { 48895c2438 488bfa 4889742440 488d5920 33f6 0f1f00 488b13 }
            // n = 7, score = 100
            //   48895c2438           | mov                 ecx, ebp
            //   488bfa               | je                  0x263
            //   4889742440           | mov                 edi, dword ptr [ebx + 0x74]
            //   488d5920             | test                edi, edi
            //   33f6                 | jne                 0x136
            //   0f1f00               | test                dword ptr [ebx + 0x80], 0x100000
            //   488b13               | je                  0x36b

        $sequence_3 = { 84c0 0f84b5f7ffff 4c8d25b2df0200 498bcc 49391f 741c 0fb711 }
            // n = 7, score = 100
            //   84c0                 | lea                 eax, [0xfffdee85]
            //   0f84b5f7ffff         | dec                 eax
            //   4c8d25b2df0200       | mov                 dword ptr [esp + 0x28], eax
            //   498bcc               | dec                 eax
            //   49391f               | lea                 eax, [0xfffe8ac9]
            //   741c                 | dec                 eax
            //   0fb711               | mov                 dword ptr [esp + 0x20], eax

        $sequence_4 = { 4c897580 48c7458807000000 664489742470 ba68000000 488d4c2470 e8???????? 4c8bd0 }
            // n = 7, score = 100
            //   4c897580             | inc                 esp
            //   48c7458807000000     | lea                 eax, [eax + 0x30]
            //   664489742470         | dec                 eax
            //   ba68000000           | mov                 dword ptr [ebp - 0x28], eax
            //   488d4c2470           | dec                 eax
            //   e8????????           |                     
            //   4c8bd0               | mov                 dword ptr [ebp - 0x20], eax

        $sequence_5 = { ff15???????? 488b4e18 ba6d230000 ff15???????? 33d2 488bc8 448d4201 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488b4e18             | movzx               eax, byte ptr [ecx + eax]
            //   ba6d230000           | dec                 esp
            //   ff15????????         |                     
            //   33d2                 | cmovae              ecx, dword ptr [esp + 0x38]
            //   488bc8               | dec                 esp
            //   448d4201             | mov                 eax, ebx

        $sequence_6 = { 498b06 b230 498bce 488b4040 ff15???????? 408af8 660f6f05???????? }
            // n = 7, score = 100
            //   498b06               | ja                  0x4fe
            //   b230                 | xor                 eax, eax
            //   498bce               | dec                 eax
            //   488b4040             | mov                 edx, dword ptr [ebp - 0x58]
            //   ff15????????         |                     
            //   408af8               | dec                 eax
            //   660f6f05????????     |                     

        $sequence_7 = { 660bd0 b800240000 03c2 66413bc5 0f8787000000 0fb7c2 2d00dc0000 }
            // n = 7, score = 100
            //   660bd0               | add                 eax, -8
            //   b800240000           | dec                 eax
            //   03c2                 | cmp                 eax, 0x1f
            //   66413bc5             | ja                  0x2f79
            //   0f8787000000         | dec                 eax
            //   0fb7c2               | mov                 dword ptr [ebp - 0x38], esi
            //   2d00dc0000           | dec                 eax

        $sequence_8 = { 410f1007 0f29442460 4d85f6 7427 408a7c2420 498bf2 408ad7 }
            // n = 7, score = 100
            //   410f1007             | dec                 eax
            //   0f29442460           | mov                 eax, dword ptr [eax + 0x48]
            //   4d85f6               | mov                 edi, eax
            //   7427                 | mov                 dword ptr [esp + 0x68], eax
            //   408a7c2420           | inc                 esp
            //   498bf2               | add                 esi, edx
            //   408ad7               | inc                 esp

        $sequence_9 = { eb03 498bff 4c8bc6 488bd7 eb55 488b3d???????? 4885ff }
            // n = 7, score = 100
            //   eb03                 | mov                 dword ptr [esp + 0x20], edi
            //   498bff               | dec                 eax
            //   4c8bc6               | shr                 eax, 0x3f
            //   488bd7               | dec                 esp
            //   eb55                 | add                 esi, eax
            //   488b3d????????       |                     
            //   4885ff               | dec                 ecx

    condition:
        7 of them and filesize < 2659328
}