rule win_winmm_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.winmm."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.winmm"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 33d2 c3 55 8bec 56 ff7514 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   33d2                 | xor                 edx, edx
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   56                   | push                esi
            //   ff7514               | push                dword ptr [ebp + 0x14]

        $sequence_1 = { b963000100 3bc1 0f8f92000000 0f84bb000000 83e843 }
            // n = 5, score = 200
            //   b963000100           | mov                 ecx, 0x10063
            //   3bc1                 | cmp                 eax, ecx
            //   0f8f92000000         | jg                  0x98
            //   0f84bb000000         | je                  0xc1
            //   83e843               | sub                 eax, 0x43

        $sequence_2 = { 7506 016c2410 eb29 663d2a00 750b }
            // n = 5, score = 200
            //   7506                 | jne                 8
            //   016c2410             | add                 dword ptr [esp + 0x10], ebp
            //   eb29                 | jmp                 0x2b
            //   663d2a00             | cmp                 ax, 0x2a
            //   750b                 | jne                 0xd

        $sequence_3 = { 7404 03c6 eb02 33c0 3bc1 }
            // n = 5, score = 200
            //   7404                 | je                  6
            //   03c6                 | add                 eax, esi
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   3bc1                 | cmp                 eax, ecx

        $sequence_4 = { 663d2000 750b 668b042e 03f5 663bc7 75c0 397c2428 }
            // n = 7, score = 200
            //   663d2000             | cmp                 ax, 0x20
            //   750b                 | jne                 0xd
            //   668b042e             | mov                 ax, word ptr [esi + ebp]
            //   03f5                 | add                 esi, ebp
            //   663bc7               | cmp                 ax, di
            //   75c0                 | jne                 0xffffffc2
            //   397c2428             | cmp                 dword ptr [esp + 0x28], edi

        $sequence_5 = { f644241604 74e5 83c308 ebe3 83c304 017c2410 eb04 }
            // n = 7, score = 200
            //   f644241604           | test                byte ptr [esp + 0x16], 4
            //   74e5                 | je                  0xffffffe7
            //   83c308               | add                 ebx, 8
            //   ebe3                 | jmp                 0xffffffe5
            //   83c304               | add                 ebx, 4
            //   017c2410             | add                 dword ptr [esp + 0x10], edi
            //   eb04                 | jmp                 6

        $sequence_6 = { 6685c0 74c9 50 e8???????? 85c0 59 }
            // n = 6, score = 200
            //   6685c0               | test                ax, ax
            //   74c9                 | je                  0xffffffcb
            //   50                   | push                eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx

        $sequence_7 = { f644241604 74e5 83c308 ebe3 }
            // n = 4, score = 200
            //   f644241604           | test                byte ptr [esp + 0x16], 4
            //   74e5                 | je                  0xffffffe7
            //   83c308               | add                 ebx, 8
            //   ebe3                 | jmp                 0xffffffe5

        $sequence_8 = { 8b7c2418 5d ff74240c 8bcf e8???????? ff742418 ff742424 }
            // n = 7, score = 200
            //   8b7c2418             | mov                 edi, dword ptr [esp + 0x18]
            //   5d                   | pop                 ebp
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   ff742424             | push                dword ptr [esp + 0x24]

        $sequence_9 = { 83c304 85c0 7505 6a06 5f }
            // n = 5, score = 200
            //   83c304               | add                 ebx, 4
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   6a06                 | push                6
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 278528
}