rule win_winnti_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.winnti."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.winnti"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c408 e9???????? 8b44241c 8bce 50 e8???????? }
            // n = 6, score = 200
            //   83c408               | add                 esp, 8
            //   e9????????           |                     
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { 8b0d???????? 85c9 746f 8b0d???????? 85c9 }
            // n = 5, score = 200
            //   8b0d????????         |                     
            //   85c9                 | test                ecx, ecx
            //   746f                 | je                  0x71
            //   8b0d????????         |                     
            //   85c9                 | test                ecx, ecx

        $sequence_2 = { 50 e8???????? 83c404 c7430c00000000 83c8ff }
            // n = 5, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c7430c00000000       | mov                 dword ptr [ebx + 0xc], 0
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_3 = { f7d1 49 81f904010000 0f83e9010000 53 }
            // n = 5, score = 200
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   81f904010000         | cmp                 ecx, 0x104
            //   0f83e9010000         | jae                 0x1ef
            //   53                   | push                ebx

        $sequence_4 = { 3d10a00000 0f8ff4010000 0f84e2010000 051f60ffff 83f82e 0f8700010000 33d2 }
            // n = 7, score = 200
            //   3d10a00000           | cmp                 eax, 0xa010
            //   0f8ff4010000         | jg                  0x1fa
            //   0f84e2010000         | je                  0x1e8
            //   051f60ffff           | add                 eax, 0xffff601f
            //   83f82e               | cmp                 eax, 0x2e
            //   0f8700010000         | ja                  0x106
            //   33d2                 | xor                 edx, edx

        $sequence_5 = { 8d4c2413 c1e206 51 6a02 }
            // n = 4, score = 200
            //   8d4c2413             | lea                 ecx, [esp + 0x13]
            //   c1e206               | shl                 edx, 6
            //   51                   | push                ecx
            //   6a02                 | push                2

        $sequence_6 = { 3c02 7519 8b4c2430 8b442424 8d53ec }
            // n = 5, score = 200
            //   3c02                 | cmp                 al, 2
            //   7519                 | jne                 0x1b
            //   8b4c2430             | mov                 ecx, dword ptr [esp + 0x30]
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   8d53ec               | lea                 edx, [ebx - 0x14]

        $sequence_7 = { e8???????? 85c0 7e24 8b54241c 83c201 83d700 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7e24                 | jle                 0x26
            //   8b54241c             | mov                 edx, dword ptr [esp + 0x1c]
            //   83c201               | add                 edx, 1
            //   83d700               | adc                 edi, 0

        $sequence_8 = { 72e2 eb04 8b6c1f02 488b742460 4863cd 8bd7 }
            // n = 6, score = 100
            //   72e2                 | inc                 ecx
            //   eb04                 | pop                 edi
            //   8b6c1f02             | inc                 ebp
            //   488b742460           | xor                 eax, eax
            //   4863cd               | dec                 eax
            //   8bd7                 | mov                 ecx, eax

        $sequence_9 = { 488bc7 4c8d9c24d0000000 498b5b20 498b7328 498be3 415f }
            // n = 6, score = 100
            //   488bc7               | dec                 eax
            //   4c8d9c24d0000000     | mov                 eax, edi
            //   498b5b20             | dec                 esp
            //   498b7328             | lea                 ebx, [esp + 0xd0]
            //   498be3               | dec                 ecx
            //   415f                 | mov                 ebx, dword ptr [ebx + 0x20]

        $sequence_10 = { ff15???????? 488d15af4b0100 488bcb 488905???????? ff15???????? 488d15884b0100 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   488d15af4b0100       | inc                 esp
            //   488bcb               | mov                 eax, ebx
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488d15884b0100       | xor                 edx, edx

        $sequence_11 = { 488d0d33f1ffff 4885c0 7422 8930 488d7808 }
            // n = 5, score = 100
            //   488d0d33f1ffff       | je                  0xb
            //   4885c0               | nop                 
            //   7422                 | dec                 eax
            //   8930                 | inc                 eax
            //   488d7808             | inc                 eax

        $sequence_12 = { e8???????? 488bd8 488d05d03b0100 4885db 488d4f38 480f44d8 488bd3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bd8               | cmp                 byte ptr [eax], dh
            //   488d05d03b0100       | mov                 ebx, dword ptr [esp + 0x40]
            //   4885db               | dec                 eax
            //   488d4f38             | mov                 ecx, eax
            //   480f44d8             | inc                 ecx
            //   488bd3               | mov                 ecx, 0x3000

        $sequence_13 = { 4533c0 488bc8 488bd3 ff15???????? 4d85ff }
            // n = 5, score = 100
            //   4533c0               | dec                 ecx
            //   488bc8               | mov                 esi, dword ptr [ebx + 0x28]
            //   488bd3               | dec                 ecx
            //   ff15????????         |                     
            //   4d85ff               | mov                 esp, ebx

        $sequence_14 = { eb02 33ff 488bd7 488d4d9f e8???????? }
            // n = 5, score = 100
            //   eb02                 | mov                 esi, eax
            //   33ff                 | jl                  0xffffffe9
            //   488bd7               | pop                 ebp
            //   488d4d9f             | pop                 ebx
            //   e8????????           |                     

        $sequence_15 = { 4533db 488d2d7d1c0000 8b7320 448b7324 }
            // n = 4, score = 100
            //   4533db               | mov                 edx, edi
            //   488d2d7d1c0000       | dec                 eax
            //   8b7320               | mov                 esi, dword ptr [ebp + 0x3c8]
            //   448b7324             | inc                 esp

        $sequence_16 = { 4889842400020000 8b4108 4c8bc2 4533c9 41894004 4889542420 33d2 }
            // n = 7, score = 100
            //   4889842400020000     | dec                 eax
            //   8b4108               | mov                 ecx, ebx
            //   4c8bc2               | dec                 eax
            //   4533c9               | cmp                 dword ptr [ebp + 0xf], 0x10
            //   41894004             | jb                  0x1a
            //   4889542420           | dec                 esp
            //   33d2                 | lea                 esp, [0xf1b6]

        $sequence_17 = { 4c8d25b6f10000 498b0c24 4d8bc5 488bd3 e8???????? }
            // n = 5, score = 100
            //   4c8d25b6f10000       | nop                 
            //   498b0c24             | dec                 eax
            //   4d8bc5               | lea                 ecx, [ebp + 0x80]
            //   488bd3               | nop                 
            //   e8????????           |                     

        $sequence_18 = { 488b8d00010000 ff15???????? 90 488d8d80000000 ff15???????? 90 }
            // n = 6, score = 100
            //   488b8d00010000       | mov                 eax, eax
            //   ff15????????         |                     
            //   90                   | inc                 ebp
            //   488d8d80000000       | test                eax, eax
            //   ff15????????         |                     
            //   90                   | je                  0xd6

        $sequence_19 = { 4c8bc0 488d155d520100 488bcb e8???????? 48837d0f10 7209 }
            // n = 6, score = 100
            //   4c8bc0               | mov                 esi, dword ptr [ebx + 0x20]
            //   488d155d520100       | inc                 esp
            //   488bcb               | mov                 esi, dword ptr [ebx + 0x24]
            //   e8????????           |                     
            //   48837d0f10           | dec                 eax
            //   7209                 | mov                 ecx, dword ptr [ebp + 0x100]

        $sequence_20 = { 41c6400701 eb0f 4080fe05 7509 41800880 41c6400704 410fb64807 }
            // n = 7, score = 100
            //   41c6400701           | jb                  0xffffffe4
            //   eb0f                 | jmp                 8
            //   4080fe05             | mov                 ebp, dword ptr [edi + ebx + 2]
            //   7509                 | dec                 eax
            //   41800880             | mov                 esi, dword ptr [esp + 0x60]
            //   41c6400704           | dec                 eax
            //   410fb64807           | arpl                bp, cx

        $sequence_21 = { 7409 90 48ffc0 403830 }
            // n = 4, score = 100
            //   7409                 | inc                 ecx
            //   90                   | mov                 byte ptr [eax + 7], 1
            //   48ffc0               | jmp                 0x11
            //   403830               | inc                 eax

        $sequence_22 = { 83feff 7423 83fefe 741e 488bce 488bc6 488d15f8ba0a00 }
            // n = 7, score = 100
            //   83feff               | pop                 edi
            //   7423                 | pop                 esi
            //   83fefe               | ret                 
            //   741e                 | dec                 esp
            //   488bce               | mov                 eax, eax
            //   488bc6               | dec                 eax
            //   488d15f8ba0a00       | lea                 edx, [0x1525d]

        $sequence_23 = { 488bb5c8030000 448bc0 4585c0 0f84ca000000 }
            // n = 4, score = 100
            //   488bb5c8030000       | dec                 eax
            //   448bc0               | mov                 edx, ebx
            //   4585c0               | dec                 ebp
            //   0f84ca000000         | test                edi, edi

    condition:
        7 of them and filesize < 1581056
}