rule win_xiaoba_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.xiaoba."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xiaoba"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b801000000 85c0 0f840a000000 b88033e101 e9???????? 8b451c 8945f8 }
            // n = 7, score = 100
            //   b801000000           | mov                 eax, 1
            //   85c0                 | test                eax, eax
            //   0f840a000000         | je                  0x10
            //   b88033e101           | mov                 eax, 0x1e13380
            //   e9????????           |                     
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_1 = { 8b4f04 50 8d942494000000 50 52 50 8d442478 }
            // n = 7, score = 100
            //   8b4f04               | mov                 ecx, dword ptr [edi + 4]
            //   50                   | push                eax
            //   8d942494000000       | lea                 edx, [esp + 0x94]
            //   50                   | push                eax
            //   52                   | push                edx
            //   50                   | push                eax
            //   8d442478             | lea                 eax, [esp + 0x78]

        $sequence_2 = { 895c241c 8907 8b0d???????? 8d6e5c 894d00 899e94000000 c78690000000b8905f00 }
            // n = 7, score = 100
            //   895c241c             | mov                 dword ptr [esp + 0x1c], ebx
            //   8907                 | mov                 dword ptr [edi], eax
            //   8b0d????????         |                     
            //   8d6e5c               | lea                 ebp, [esi + 0x5c]
            //   894d00               | mov                 dword ptr [ebp], ecx
            //   899e94000000         | mov                 dword ptr [esi + 0x94], ebx
            //   c78690000000b8905f00     | mov    dword ptr [esi + 0x90], 0x5f90b8

        $sequence_3 = { 8a1e 84db 7403 c60600 57 51 e8???????? }
            // n = 7, score = 100
            //   8a1e                 | mov                 bl, byte ptr [esi]
            //   84db                 | test                bl, bl
            //   7403                 | je                  5
            //   c60600               | mov                 byte ptr [esi], 0
            //   57                   | push                edi
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_4 = { 8b8f80000000 8bc2 894d08 8b4e28 83c004 3bc1 7607 }
            // n = 7, score = 100
            //   8b8f80000000         | mov                 ecx, dword ptr [edi + 0x80]
            //   8bc2                 | mov                 eax, edx
            //   894d08               | mov                 dword ptr [ebp + 8], ecx
            //   8b4e28               | mov                 ecx, dword ptr [esi + 0x28]
            //   83c004               | add                 eax, 4
            //   3bc1                 | cmp                 eax, ecx
            //   7607                 | jbe                 9

        $sequence_5 = { 52 50 6a00 8b7c2454 8b4d04 57 6a00 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   50                   | push                eax
            //   6a00                 | push                0
            //   8b7c2454             | mov                 edi, dword ptr [esp + 0x54]
            //   8b4d04               | mov                 ecx, dword ptr [ebp + 4]
            //   57                   | push                edi
            //   6a00                 | push                0

        $sequence_6 = { 85c0 0f8407040000 8b6e34 85ed 0f84fc030000 8b4508 85c0 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f8407040000         | je                  0x40d
            //   8b6e34               | mov                 ebp, dword ptr [esi + 0x34]
            //   85ed                 | test                ebp, ebp
            //   0f84fc030000         | je                  0x402
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   85c0                 | test                eax, eax

        $sequence_7 = { 8b4e78 50 51 e8???????? 8b5634 83c408 }
            // n = 6, score = 100
            //   8b4e78               | mov                 ecx, dword ptr [esi + 0x78]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b5634               | mov                 edx, dword ptr [esi + 0x34]
            //   83c408               | add                 esp, 8

        $sequence_8 = { e8???????? 8b4c2414 83c404 85c9 8944241c 755c 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   83c404               | add                 esp, 4
            //   85c9                 | test                ecx, ecx
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   755c                 | jne                 0x5e
            //   50                   | push                eax

        $sequence_9 = { 8b942488000000 6a00 50 8b842480000000 53 56 50 }
            // n = 7, score = 100
            //   8b942488000000       | mov                 edx, dword ptr [esp + 0x88]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8b842480000000       | mov                 eax, dword ptr [esp + 0x80]
            //   53                   | push                ebx
            //   56                   | push                esi
            //   50                   | push                eax

    condition:
        7 of them and filesize < 5177344
}