rule win_xtunnel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.xtunnel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xtunnel"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d42fc 3bf0 0f86f9fcffff 3bf2 0f85d2fcffff 837f6c00 0f851a010000 }
            // n = 7, score = 1200
            //   8d42fc               | lea                 eax, [edx - 4]
            //   3bf0                 | cmp                 esi, eax
            //   0f86f9fcffff         | jbe                 0xfffffcff
            //   3bf2                 | cmp                 esi, edx
            //   0f85d2fcffff         | jne                 0xfffffcd8
            //   837f6c00             | cmp                 dword ptr [edi + 0x6c], 0
            //   0f851a010000         | jne                 0x120

        $sequence_1 = { 8d5c0301 46 89442410 3bdd }
            // n = 4, score = 1200
            //   8d5c0301             | lea                 ebx, [ebx + eax + 1]
            //   46                   | inc                 esi
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   3bdd                 | cmp                 ebx, ebp

        $sequence_2 = { e9???????? 83fb0b 0f859a000000 813ffffe0000 0f845b020000 0fb61e }
            // n = 6, score = 1200
            //   e9????????           |                     
            //   83fb0b               | cmp                 ebx, 0xb
            //   0f859a000000         | jne                 0xa0
            //   813ffffe0000         | cmp                 dword ptr [edi], 0xfeff
            //   0f845b020000         | je                  0x261
            //   0fb61e               | movzx               ebx, byte ptr [esi]

        $sequence_3 = { 8d0c18 81f9f0ff0000 0f8f00020000 8b542410 83c105 c1f908 }
            // n = 6, score = 1200
            //   8d0c18               | lea                 ecx, [eax + ebx]
            //   81f9f0ff0000         | cmp                 ecx, 0xfff0
            //   0f8f00020000         | jg                  0x206
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   83c105               | add                 ecx, 5
            //   c1f908               | sar                 ecx, 8

        $sequence_4 = { 8b11 83c202 52 e8???????? }
            // n = 4, score = 1200
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   83c202               | add                 edx, 2
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_5 = { 8bcf 2bc8 83e905 0f88f6050000 8b9544010000 3bd1 0f87e8050000 }
            // n = 7, score = 1200
            //   8bcf                 | mov                 ecx, edi
            //   2bc8                 | sub                 ecx, eax
            //   83e905               | sub                 ecx, 5
            //   0f88f6050000         | js                  0x5fc
            //   8b9544010000         | mov                 edx, dword ptr [ebp + 0x144]
            //   3bd1                 | cmp                 edx, ecx
            //   0f87e8050000         | ja                  0x5ee

        $sequence_6 = { 8d5c0302 83c602 89442410 3bdd }
            // n = 4, score = 1200
            //   8d5c0302             | lea                 ebx, [ebx + eax + 2]
            //   83c602               | add                 esi, 2
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   3bdd                 | cmp                 ebx, ebp

        $sequence_7 = { 8bcb 83c602 2bcf 8d543102 3b542414 7646 }
            // n = 6, score = 1200
            //   8bcb                 | mov                 ecx, ebx
            //   83c602               | add                 esi, 2
            //   2bcf                 | sub                 ecx, edi
            //   8d543102             | lea                 edx, [ecx + esi + 2]
            //   3b542414             | cmp                 edx, dword ptr [esp + 0x14]
            //   7646                 | jbe                 0x48

        $sequence_8 = { 8d7071 6848010000 eb13 7933 }
            // n = 4, score = 1200
            //   8d7071               | lea                 esi, [eax + 0x71]
            //   6848010000           | push                0x148
            //   eb13                 | jmp                 0x15
            //   7933                 | jns                 0x35

        $sequence_9 = { e8???????? 99 b960000000 f7f9 }
            // n = 4, score = 1200
            //   e8????????           |                     
            //   99                   | cdq                 
            //   b960000000           | mov                 ecx, 0x60
            //   f7f9                 | idiv                ecx

        $sequence_10 = { 8b5118 895018 8b11 8910 }
            // n = 4, score = 1000
            //   8b5118               | mov                 edx, dword ptr [ecx + 0x18]
            //   895018               | mov                 dword ptr [eax + 0x18], edx
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8910                 | mov                 dword ptr [eax], edx

        $sequence_11 = { 8910 8b4e14 894814 0fb7560a 6689500a 8b4e0c }
            // n = 6, score = 1000
            //   8910                 | mov                 dword ptr [eax], edx
            //   8b4e14               | mov                 ecx, dword ptr [esi + 0x14]
            //   894814               | mov                 dword ptr [eax + 0x14], ecx
            //   0fb7560a             | movzx               edx, word ptr [esi + 0xa]
            //   6689500a             | mov                 word ptr [eax + 0xa], dx
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]

        $sequence_12 = { 33c4 89442410 56 6a06 }
            // n = 4, score = 1000
            //   33c4                 | xor                 eax, esp
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   56                   | push                esi
            //   6a06                 | push                6

        $sequence_13 = { 6800400000 56 50 ff15???????? 56 e8???????? }
            // n = 6, score = 1000
            //   6800400000           | push                0x4000
            //   56                   | push                esi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_14 = { 807e1500 8975f0 74dd 8b4744 }
            // n = 4, score = 1000
            //   807e1500             | cmp                 byte ptr [esi + 0x15], 0
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   74dd                 | je                  0xffffffdf
            //   8b4744               | mov                 eax, dword ptr [edi + 0x44]

        $sequence_15 = { c6411501 c645fc04 6a18 895e58 }
            // n = 4, score = 1000
            //   c6411501             | mov                 byte ptr [ecx + 0x15], 1
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   6a18                 | push                0x18
            //   895e58               | mov                 dword ptr [esi + 0x58], ebx

        $sequence_16 = { f7d8 1bc0 83e0fb 5f 5e }
            // n = 5, score = 1000
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax
            //   83e0fb               | and                 eax, 0xfffffffb
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_17 = { 6a18 895e38 e8???????? 83c404 }
            // n = 4, score = 1000
            //   6a18                 | push                0x18
            //   895e38               | mov                 dword ptr [esi + 0x38], ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_18 = { e8???????? 83c404 8945b0 8b45b4 50 6a00 }
            // n = 6, score = 500
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945b0               | mov                 dword ptr [ebp - 0x50], eax
            //   8b45b4               | mov                 eax, dword ptr [ebp - 0x4c]
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_19 = { 83c404 8b10 895584 eb11 8b45f4 }
            // n = 5, score = 300
            //   83c404               | add                 esp, 4
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   895584               | mov                 dword ptr [ebp - 0x7c], edx
            //   eb11                 | jmp                 0x13
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_20 = { 83c404 8b10 8b4004 8b4dac }
            // n = 4, score = 300
            //   83c404               | add                 esp, 4
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   8b4dac               | mov                 ecx, dword ptr [ebp - 0x54]

        $sequence_21 = { 83c404 8b16 8910 8b45f8 }
            // n = 4, score = 300
            //   83c404               | add                 esp, 4
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8910                 | mov                 dword ptr [eax], edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_22 = { 56 57 894dfc 8b4508 0fb608 51 }
            // n = 6, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0fb608               | movzx               ecx, byte ptr [eax]
            //   51                   | push                ecx

        $sequence_23 = { 83c404 8b10 8955f8 e9???????? }
            // n = 4, score = 300
            //   83c404               | add                 esp, 4
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   e9????????           |                     

    condition:
        7 of them and filesize < 4634440
}