rule win_yayih_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.yayih."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yayih"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff35???????? ff15???????? 85c0 0f8442050000 8b45dc }
            // n = 5, score = 100
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8442050000         | je                  0x548
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]

        $sequence_1 = { 59 7510 8d85bcd8ffff 50 56 ff75fc }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   7510                 | jne                 0x12
            //   8d85bcd8ffff         | lea                 eax, [ebp - 0x2744]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_2 = { 898574ffffff ffd7 8bf8 56 2b7dd8 }
            // n = 5, score = 100
            //   898574ffffff         | mov                 dword ptr [ebp - 0x8c], eax
            //   ffd7                 | call                edi
            //   8bf8                 | mov                 edi, eax
            //   56                   | push                esi
            //   2b7dd8               | sub                 edi, dword ptr [ebp - 0x28]

        $sequence_3 = { 8d85bcd8ffff 50 e8???????? 59 8d8dbcd8ffff 83e903 803c0829 }
            // n = 7, score = 100
            //   8d85bcd8ffff         | lea                 eax, [ebp - 0x2744]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d8dbcd8ffff         | lea                 ecx, [ebp - 0x2744]
            //   83e903               | sub                 ecx, 3
            //   803c0829             | cmp                 byte ptr [eax + ecx], 0x29

        $sequence_4 = { 6a01 53 c745c464000000 895dfc 895de4 895df0 895df4 }
            // n = 7, score = 100
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   c745c464000000       | mov                 dword ptr [ebp - 0x3c], 0x64
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx

        $sequence_5 = { 50 56 6a63 e8???????? 83c414 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   56                   | push                esi
            //   6a63                 | push                0x63
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14

        $sequence_6 = { 895dcc a4 ff15???????? 3bc3 898578ffffff 0f8465110000 ff15???????? }
            // n = 7, score = 100
            //   895dcc               | mov                 dword ptr [ebp - 0x34], ebx
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   ff15????????         |                     
            //   3bc3                 | cmp                 eax, ebx
            //   898578ffffff         | mov                 dword ptr [ebp - 0x88], eax
            //   0f8465110000         | je                  0x116b
            //   ff15????????         |                     

        $sequence_7 = { 752c 3975dc 7554 3975cc 754f }
            // n = 5, score = 100
            //   752c                 | jne                 0x2e
            //   3975dc               | cmp                 dword ptr [ebp - 0x24], esi
            //   7554                 | jne                 0x56
            //   3975cc               | cmp                 dword ptr [ebp - 0x34], esi
            //   754f                 | jne                 0x51

        $sequence_8 = { ff15???????? ff35???????? ff15???????? ff35???????? ff15???????? 807dd16b 741d }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   807dd16b             | cmp                 byte ptr [ebp - 0x2f], 0x6b
            //   741d                 | je                  0x1f

        $sequence_9 = { 59 59 50 57 ffd6 a3???????? eb54 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   a3????????           |                     
            //   eb54                 | jmp                 0x56

    condition:
        7 of them and filesize < 57344
}