rule win_zebrocy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zebrocy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zebrocy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945e4 e8???????? 89f9 89c6 e8???????? 8b55e4 }
            // n = 6, score = 100
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   e8????????           |                     
            //   89f9                 | mov                 ecx, edi
            //   89c6                 | mov                 esi, eax
            //   e8????????           |                     
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]

        $sequence_1 = { 8d45f4 64a300000000 8b01 8d7160 8b4804 8975f0 c74431a05c444200 }
            // n = 7, score = 100
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8d7160               | lea                 esi, [ecx + 0x60]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   c74431a05c444200     | mov                 dword ptr [ecx + esi - 0x60], 0x42445c

        $sequence_2 = { ff0d???????? ff15???????? 8b0d???????? 89048d489b4200 }
            // n = 4, score = 100
            //   ff0d????????         |                     
            //   ff15????????         |                     
            //   8b0d????????         |                     
            //   89048d489b4200       | mov                 dword ptr [ecx*4 + 0x429b48], eax

        $sequence_3 = { 8bc8 8bc6 c644246001 e8???????? be10000000 3974242c 720d }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   8bc6                 | mov                 eax, esi
            //   c644246001           | mov                 byte ptr [esp + 0x60], 1
            //   e8????????           |                     
            //   be10000000           | mov                 esi, 0x10
            //   3974242c             | cmp                 dword ptr [esp + 0x2c], esi
            //   720d                 | jb                  0xf

        $sequence_4 = { a3???????? 8078086c 7507 c605????????01 }
            // n = 4, score = 100
            //   a3????????           |                     
            //   8078086c             | cmp                 byte ptr [eax + 8], 0x6c
            //   7507                 | jne                 9
            //   c605????????01       |                     

        $sequence_5 = { 8d51bf 55 8d4120 80fa19 89e5 }
            // n = 5, score = 100
            //   8d51bf               | lea                 edx, [ecx - 0x41]
            //   55                   | push                ebp
            //   8d4120               | lea                 eax, [ecx + 0x20]
            //   80fa19               | cmp                 dl, 0x19
            //   89e5                 | mov                 ebp, esp

        $sequence_6 = { c686c800000043 c6864b01000043 c74668d0874200 6a0d }
            // n = 4, score = 100
            //   c686c800000043       | mov                 byte ptr [esi + 0xc8], 0x43
            //   c6864b01000043       | mov                 byte ptr [esi + 0x14b], 0x43
            //   c74668d0874200       | mov                 dword ptr [esi + 0x68], 0x4287d0
            //   6a0d                 | push                0xd

        $sequence_7 = { 83f83f 7f07 894c8204 40 8902 5d }
            // n = 6, score = 100
            //   83f83f               | cmp                 eax, 0x3f
            //   7f07                 | jg                  9
            //   894c8204             | mov                 dword ptr [edx + eax*4 + 4], ecx
            //   40                   | inc                 eax
            //   8902                 | mov                 dword ptr [edx], eax
            //   5d                   | pop                 ebp

        $sequence_8 = { 53 8d70ff 31db 31c0 39f3 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   8d70ff               | lea                 esi, [eax - 1]
            //   31db                 | xor                 ebx, ebx
            //   31c0                 | xor                 eax, eax
            //   39f3                 | cmp                 ebx, esi

        $sequence_9 = { 7505 e8???????? 84db 7407 }
            // n = 4, score = 100
            //   7505                 | jne                 7
            //   e8????????           |                     
            //   84db                 | test                bl, bl
            //   7407                 | je                  9

        $sequence_10 = { b9ffff0000 663bc8 750e c745ec04000000 8da42400000000 837dec00 }
            // n = 6, score = 100
            //   b9ffff0000           | mov                 ecx, 0xffff
            //   663bc8               | cmp                 cx, ax
            //   750e                 | jne                 0x10
            //   c745ec04000000       | mov                 dword ptr [ebp - 0x14], 4
            //   8da42400000000       | lea                 esp, [esp]
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0

        $sequence_11 = { 8b4508 33f6 89b578ffffff ba0f000000 895314 }
            // n = 5, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   33f6                 | xor                 esi, esi
            //   89b578ffffff         | mov                 dword ptr [ebp - 0x88], esi
            //   ba0f000000           | mov                 edx, 0xf
            //   895314               | mov                 dword ptr [ebx + 0x14], edx

        $sequence_12 = { 42 89f9 884b08 ebe7 83c42c 5b }
            // n = 6, score = 100
            //   42                   | inc                 edx
            //   89f9                 | mov                 ecx, edi
            //   884b08               | mov                 byte ptr [ebx + 8], cl
            //   ebe7                 | jmp                 0xffffffe9
            //   83c42c               | add                 esp, 0x2c
            //   5b                   | pop                 ebx

        $sequence_13 = { e9???????? 8d4dd4 e9???????? 8d8d08ffffff e9???????? 8d4db8 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   e9????????           |                     
            //   8d8d08ffffff         | lea                 ecx, [ebp - 0xf8]
            //   e9????????           |                     
            //   8d4db8               | lea                 ecx, [ebp - 0x48]

        $sequence_14 = { 7306 8d8508f7ffff 8a1c38 8db598f6ffff e8???????? }
            // n = 5, score = 100
            //   7306                 | jae                 8
            //   8d8508f7ffff         | lea                 eax, [ebp - 0x8f8]
            //   8a1c38               | mov                 bl, byte ptr [eax + edi]
            //   8db598f6ffff         | lea                 esi, [ebp - 0x968]
            //   e8????????           |                     

        $sequence_15 = { eb50 31d2 89d9 e8???????? }
            // n = 4, score = 100
            //   eb50                 | jmp                 0x52
            //   31d2                 | xor                 edx, edx
            //   89d9                 | mov                 ecx, ebx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 393216
}