rule win_zeoticus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zeoticus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zeoticus"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 660f62f9 660fd4bc2400010000 0f284c2430 660fd4f8 660f3a0f4c241008 660fefdf 8b942414010000 }
            // n = 7, score = 100
            //   660f62f9             | punpckldq           xmm7, xmm1
            //   660fd4bc2400010000     | paddq    xmm7, xmmword ptr [esp + 0x100]
            //   0f284c2430           | movaps              xmm1, xmmword ptr [esp + 0x30]
            //   660fd4f8             | paddq               xmm7, xmm0
            //   660f3a0f4c241008     | palignr             xmm1, xmmword ptr [esp + 0x10], 8
            //   660fefdf             | pxor                xmm3, xmm7
            //   8b942414010000       | mov                 edx, dword ptr [esp + 0x114]

        $sequence_1 = { 6a15 ba???????? b90b7a9652 e8???????? 83c408 a3???????? 680c0e0000 }
            // n = 7, score = 100
            //   6a15                 | push                0x15
            //   ba????????           |                     
            //   b90b7a9652           | mov                 ecx, 0x52967a0b
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   a3????????           |                     
            //   680c0e0000           | push                0xe0c

        $sequence_2 = { 33c9 66c787701110000001 90 8a8100674300 88840f90101000 41 }
            // n = 6, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   66c787701110000001     | mov    word ptr [edi + 0x101170], 0x100
            //   90                   | nop                 
            //   8a8100674300         | mov                 al, byte ptr [ecx + 0x436700]
            //   88840f90101000       | mov                 byte ptr [edi + ecx + 0x101090], al
            //   41                   | inc                 ecx

        $sequence_3 = { 2b9d74ffffff 898568ffffff 8b8544ffffff 2b4594 8b7dc8 2bbd78ffffff }
            // n = 6, score = 100
            //   2b9d74ffffff         | sub                 ebx, dword ptr [ebp - 0x8c]
            //   898568ffffff         | mov                 dword ptr [ebp - 0x98], eax
            //   8b8544ffffff         | mov                 eax, dword ptr [ebp - 0xbc]
            //   2b4594               | sub                 eax, dword ptr [ebp - 0x6c]
            //   8b7dc8               | mov                 edi, dword ptr [ebp - 0x38]
            //   2bbd78ffffff         | sub                 edi, dword ptr [ebp - 0x88]

        $sequence_4 = { 660f62ca 660f6e9424a4000000 0f295c2430 0f28442430 660f6e5c2444 660f62c1 660f6e4c2440 }
            // n = 7, score = 100
            //   660f62ca             | punpckldq           xmm1, xmm2
            //   660f6e9424a4000000     | movd    xmm2, dword ptr [esp + 0xa4]
            //   0f295c2430           | movaps              xmmword ptr [esp + 0x30], xmm3
            //   0f28442430           | movaps              xmm0, xmmword ptr [esp + 0x30]
            //   660f6e5c2444         | movd                xmm3, dword ptr [esp + 0x44]
            //   660f62c1             | punpckldq           xmm0, xmm1
            //   660f6e4c2440         | movd                xmm1, dword ptr [esp + 0x40]

        $sequence_5 = { 8b74240c ba???????? 680f8ed51c 6a16 b932347982 c744241801000000 c744242402000000 }
            // n = 7, score = 100
            //   8b74240c             | mov                 esi, dword ptr [esp + 0xc]
            //   ba????????           |                     
            //   680f8ed51c           | push                0x1cd58e0f
            //   6a16                 | push                0x16
            //   b932347982           | mov                 ecx, 0x82793432
            //   c744241801000000     | mov                 dword ptr [esp + 0x18], 1
            //   c744242402000000     | mov                 dword ptr [esp + 0x24], 2

        $sequence_6 = { 8d4901 83ea01 75f5 8bcb 2bf3 ba20000000 0f1f8000000000 }
            // n = 7, score = 100
            //   8d4901               | lea                 ecx, [ecx + 1]
            //   83ea01               | sub                 edx, 1
            //   75f5                 | jne                 0xfffffff7
            //   8bcb                 | mov                 ecx, ebx
            //   2bf3                 | sub                 esi, ebx
            //   ba20000000           | mov                 edx, 0x20
            //   0f1f8000000000       | nop                 dword ptr [eax]

        $sequence_7 = { 6a03 68???????? 6a0a 68???????? e8???????? 685d0b4077 6a0a }
            // n = 7, score = 100
            //   6a03                 | push                3
            //   68????????           |                     
            //   6a0a                 | push                0xa
            //   68????????           |                     
            //   e8????????           |                     
            //   685d0b4077           | push                0x77400b5d
            //   6a0a                 | push                0xa

        $sequence_8 = { 660f72d00e 660f72f412 660fefa590feffff 660fefe0 0f28c5 660ffec7 0f29a530ffffff }
            // n = 7, score = 100
            //   660f72d00e           | psrld               xmm0, 0xe
            //   660f72f412           | pslld               xmm4, 0x12
            //   660fefa590feffff     | pxor                xmm4, xmmword ptr [ebp - 0x170]
            //   660fefe0             | pxor                xmm4, xmm0
            //   0f28c5               | movaps              xmm0, xmm5
            //   660ffec7             | paddd               xmm0, xmm7
            //   0f29a530ffffff       | movaps              xmmword ptr [ebp - 0xd0], xmm4

        $sequence_9 = { 2b9d78ffffff 2bbd7cffffff 2b7580 2b5584 898524ffffff 8b8534ffffff 8945b4 }
            // n = 7, score = 100
            //   2b9d78ffffff         | sub                 ebx, dword ptr [ebp - 0x88]
            //   2bbd7cffffff         | sub                 edi, dword ptr [ebp - 0x84]
            //   2b7580               | sub                 esi, dword ptr [ebp - 0x80]
            //   2b5584               | sub                 edx, dword ptr [ebp - 0x7c]
            //   898524ffffff         | mov                 dword ptr [ebp - 0xdc], eax
            //   8b8534ffffff         | mov                 eax, dword ptr [ebp - 0xcc]
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax

    condition:
        7 of them and filesize < 468992
}