rule win_zerot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zerot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zerot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d3c1b 33c9 85ff 7e50 83c202 660f1f440000 8b460c }
            // n = 7, score = 200
            //   8d3c1b               | lea                 edi, [ebx + ebx]
            //   33c9                 | xor                 ecx, ecx
            //   85ff                 | test                edi, edi
            //   7e50                 | jle                 0x52
            //   83c202               | add                 edx, 2
            //   660f1f440000         | nop                 word ptr [eax + eax]
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]

        $sequence_1 = { 8d4f01 895518 8a07 47 84c0 75f9 6800010000 }
            // n = 7, score = 200
            //   8d4f01               | lea                 ecx, [edi + 1]
            //   895518               | mov                 dword ptr [ebp + 0x18], edx
            //   8a07                 | mov                 al, byte ptr [edi]
            //   47                   | inc                 edi
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb
            //   6800010000           | push                0x100

        $sequence_2 = { ffd6 8b8d74f6ffff 41 03c1 }
            // n = 4, score = 200
            //   ffd6                 | call                esi
            //   8b8d74f6ffff         | mov                 ecx, dword ptr [ebp - 0x98c]
            //   41                   | inc                 ecx
            //   03c1                 | add                 eax, ecx

        $sequence_3 = { 6aff 8d8554ffffff 50 6a00 6a00 }
            // n = 5, score = 200
            //   6aff                 | push                -1
            //   8d8554ffffff         | lea                 eax, [ebp - 0xac]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_4 = { 880432 8a57fb c0e202 02d0 8b45e8 }
            // n = 5, score = 200
            //   880432               | mov                 byte ptr [edx + esi], al
            //   8a57fb               | mov                 dl, byte ptr [edi - 5]
            //   c0e202               | shl                 dl, 2
            //   02d0                 | add                 dl, al
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_5 = { c7458401000000 33c0 66894588 8d459c 50 }
            // n = 5, score = 200
            //   c7458401000000       | mov                 dword ptr [ebp - 0x7c], 1
            //   33c0                 | xor                 eax, eax
            //   66894588             | mov                 word ptr [ebp - 0x78], ax
            //   8d459c               | lea                 eax, [ebp - 0x64]
            //   50                   | push                eax

        $sequence_6 = { bb06000000 50 8d8594feffff 50 }
            // n = 4, score = 200
            //   bb06000000           | mov                 ebx, 6
            //   50                   | push                eax
            //   8d8594feffff         | lea                 eax, [ebp - 0x16c]
            //   50                   | push                eax

        $sequence_7 = { 740c 81bdecf9ffffc8000000 7421 8b85e8f9ffff }
            // n = 4, score = 200
            //   740c                 | je                  0xe
            //   81bdecf9ffffc8000000     | cmp    dword ptr [ebp - 0x614], 0xc8
            //   7421                 | je                  0x23
            //   8b85e8f9ffff         | mov                 eax, dword ptr [ebp - 0x618]

        $sequence_8 = { 85c0 755e ff15???????? 8d857cffffff 50 ffd6 }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   755e                 | jne                 0x60
            //   ff15????????         |                     
            //   8d857cffffff         | lea                 eax, [ebp - 0x84]
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_9 = { 0f1f440000 8b460c 8a44082a 2401 88040a }
            // n = 5, score = 200
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   8a44082a             | mov                 al, byte ptr [eax + ecx + 0x2a]
            //   2401                 | and                 al, 1
            //   88040a               | mov                 byte ptr [edx + ecx], al

    condition:
        7 of them and filesize < 303104
}