rule win_zeus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zeus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zeus"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb58 833f00 7651 8b5f08 }
            // n = 4, score = 700
            //   eb58                 | jmp                 0x5a
            //   833f00               | cmp                 dword ptr [edi], 0
            //   7651                 | jbe                 0x53
            //   8b5f08               | mov                 ebx, dword ptr [edi + 8]

        $sequence_1 = { eb06 66a1???????? 68???????? 668906 6a00 8d45fc e8???????? }
            // n = 7, score = 600
            //   eb06                 | jmp                 8
            //   66a1????????         |                     
            //   68????????           |                     
            //   668906               | mov                 word ptr [esi], ax
            //   6a00                 | push                0
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   e8????????           |                     

        $sequence_2 = { c9 c3 83f903 7515 }
            // n = 4, score = 600
            //   c9                   | leave               
            //   c3                   | ret                 
            //   83f903               | cmp                 ecx, 3
            //   7515                 | jne                 0x17

        $sequence_3 = { 8d443604 50 a1???????? 57 6a01 6a00 }
            // n = 6, score = 600
            //   8d443604             | lea                 eax, [esi + esi + 4]
            //   50                   | push                eax
            //   a1????????           |                     
            //   57                   | push                edi
            //   6a01                 | push                1
            //   6a00                 | push                0

        $sequence_4 = { 80f93f 740a 80f92f 7405 4e }
            // n = 5, score = 600
            //   80f93f               | cmp                 cl, 0x3f
            //   740a                 | je                  0xc
            //   80f92f               | cmp                 cl, 0x2f
            //   7405                 | je                  7
            //   4e                   | dec                 esi

        $sequence_5 = { c9 c3 6a1c 58 e8???????? 85c0 7406 }
            // n = 7, score = 600
            //   c9                   | leave               
            //   c3                   | ret                 
            //   6a1c                 | push                0x1c
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7406                 | je                  8

        $sequence_6 = { 8b3d???????? 3bfe 744f 56 }
            // n = 4, score = 600
            //   8b3d????????         |                     
            //   3bfe                 | cmp                 edi, esi
            //   744f                 | je                  0x51
            //   56                   | push                esi

        $sequence_7 = { 84db 742a ff75f8 ff75f0 ff7510 ff750c }
            // n = 6, score = 600
            //   84db                 | test                bl, bl
            //   742a                 | je                  0x2c
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_8 = { 8bf3 6810270000 ff35???????? ff15???????? }
            // n = 4, score = 500
            //   8bf3                 | mov                 esi, ebx
            //   6810270000           | push                0x2710
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_9 = { 891d???????? 891d???????? ffd6 68???????? }
            // n = 4, score = 500
            //   891d????????         |                     
            //   891d????????         |                     
            //   ffd6                 | call                esi
            //   68????????           |                     

        $sequence_10 = { e8???????? 84c0 7442 6a10 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7442                 | je                  0x44
            //   6a10                 | push                0x10

        $sequence_11 = { 8d8db0fdffff e8???????? 8ad8 84db }
            // n = 4, score = 400
            //   8d8db0fdffff         | lea                 ecx, [ebp - 0x250]
            //   e8????????           |                     
            //   8ad8                 | mov                 bl, al
            //   84db                 | test                bl, bl

        $sequence_12 = { ff15???????? 5e 8ac3 5b c20800 55 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   8ac3                 | mov                 al, bl
            //   5b                   | pop                 ebx
            //   c20800               | ret                 8
            //   55                   | push                ebp

        $sequence_13 = { c9 c20400 55 8bec f6451802 }
            // n = 5, score = 300
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   f6451802             | test                byte ptr [ebp + 0x18], 2

        $sequence_14 = { 7506 b364 6a14 eb18 81fb5a5c4156 }
            // n = 5, score = 200
            //   7506                 | jne                 8
            //   b364                 | mov                 bl, 0x64
            //   6a14                 | push                0x14
            //   eb18                 | jmp                 0x1a
            //   81fb5a5c4156         | cmp                 ebx, 0x56415c5a

        $sequence_15 = { b8d5000000 e8???????? 68e6010000 68???????? 6809080002 8bc6 }
            // n = 6, score = 200
            //   b8d5000000           | mov                 eax, 0xd5
            //   e8????????           |                     
            //   68e6010000           | push                0x1e6
            //   68????????           |                     
            //   6809080002           | push                0x2000809
            //   8bc6                 | mov                 eax, esi

        $sequence_16 = { e8???????? 84c0 0f84ac000000 b809080002 3945f4 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f84ac000000         | je                  0xb2
            //   b809080002           | mov                 eax, 0x2000809
            //   3945f4               | cmp                 dword ptr [ebp - 0xc], eax

        $sequence_17 = { 8b1b 81f309080002 81fb5d515047 7410 81fb4f4d4156 7408 }
            // n = 6, score = 200
            //   8b1b                 | mov                 ebx, dword ptr [ebx]
            //   81f309080002         | xor                 ebx, 0x2000809
            //   81fb5d515047         | cmp                 ebx, 0x4750515d
            //   7410                 | je                  0x12
            //   81fb4f4d4156         | cmp                 ebx, 0x56414d4f
            //   7408                 | je                  0xa

        $sequence_18 = { 5b 8bc6 c745f809080002 e8???????? 8ad8 }
            // n = 5, score = 200
            //   5b                   | pop                 ebx
            //   8bc6                 | mov                 eax, esi
            //   c745f809080002       | mov                 dword ptr [ebp - 8], 0x2000809
            //   e8????????           |                     
            //   8ad8                 | mov                 bl, al

        $sequence_19 = { 0f86e3000000 8b03 3509080002 3d5c5b4550 740b 3d59495351 }
            // n = 6, score = 200
            //   0f86e3000000         | jbe                 0xe9
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   3509080002           | xor                 eax, 0x2000809
            //   3d5c5b4550           | cmp                 eax, 0x50455b5c
            //   740b                 | je                  0xd
            //   3d59495351           | cmp                 eax, 0x51534959

        $sequence_20 = { 6809080002 8bc6 50 8d45fc 50 e8???????? }
            // n = 6, score = 200
            //   6809080002           | push                0x2000809
            //   8bc6                 | mov                 eax, esi
            //   50                   | push                eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_21 = { 57 33f6 56 50 68???????? }
            // n = 5, score = 200
            //   57                   | push                edi
            //   33f6                 | xor                 esi, esi
            //   56                   | push                esi
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_22 = { b809080002 3945f4 7713 807d0801 0f8598000000 }
            // n = 5, score = 200
            //   b809080002           | mov                 eax, 0x2000809
            //   3945f4               | cmp                 dword ptr [ebp - 0xc], eax
            //   7713                 | ja                  0x15
            //   807d0801             | cmp                 byte ptr [ebp + 8], 1
            //   0f8598000000         | jne                 0x9e

    condition:
        7 of them and filesize < 319488
}