rule win_zitmo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.zitmo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zitmo"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 8bec 81c47cffffff ff4de4 46 c9 }
            // n = 6, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81c47cffffff         | add                 esp, 0xffffff7c
            //   ff4de4               | dec                 dword ptr [ebp - 0x1c]
            //   46                   | inc                 esi
            //   c9                   | leave               

        $sequence_1 = { e8???????? f7d3 4f e8???????? 8bca }
            // n = 5, score = 200
            //   e8????????           |                     
            //   f7d3                 | not                 ebx
            //   4f                   | dec                 edi
            //   e8????????           |                     
            //   8bca                 | mov                 ecx, edx

        $sequence_2 = { 6a33 56 6831373600 6a35 68632403db e8???????? 40 }
            // n = 7, score = 200
            //   6a33                 | push                0x33
            //   56                   | push                esi
            //   6831373600           | push                0x363731
            //   6a35                 | push                0x35
            //   68632403db           | push                0xdb032463
            //   e8????????           |                     
            //   40                   | inc                 eax

        $sequence_3 = { 23c7 f7d3 f7da 48 23ca }
            // n = 5, score = 200
            //   23c7                 | and                 eax, edi
            //   f7d3                 | not                 ebx
            //   f7da                 | neg                 edx
            //   48                   | dec                 eax
            //   23ca                 | and                 ecx, edx

        $sequence_4 = { f7db 4e 03fa 23f0 03c3 2175f4 }
            // n = 6, score = 200
            //   f7db                 | neg                 ebx
            //   4e                   | dec                 esi
            //   03fa                 | add                 edi, edx
            //   23f0                 | and                 esi, eax
            //   03c3                 | add                 eax, ebx
            //   2175f4               | and                 dword ptr [ebp - 0xc], esi

        $sequence_5 = { 8bda 43 f7d3 8bf2 }
            // n = 4, score = 200
            //   8bda                 | mov                 ebx, edx
            //   43                   | inc                 ebx
            //   f7d3                 | not                 ebx
            //   8bf2                 | mov                 esi, edx

        $sequence_6 = { 0945f8 ffb5dcfeffff e8???????? c9 c20800 }
            // n = 5, score = 200
            //   0945f8               | or                  dword ptr [ebp - 8], eax
            //   ffb5dcfeffff         | push                dword ptr [ebp - 0x124]
            //   e8????????           |                     
            //   c9                   | leave               
            //   c20800               | ret                 8

        $sequence_7 = { 8bcf 23c3 8d8dc8feffff 51 }
            // n = 4, score = 200
            //   8bcf                 | mov                 ecx, edi
            //   23c3                 | and                 eax, ebx
            //   8d8dc8feffff         | lea                 ecx, [ebp - 0x138]
            //   51                   | push                ecx

        $sequence_8 = { c9 c20400 55 8bec 81c420ffffff ff8d6cffffff 8365dc34 }
            // n = 7, score = 200
            //   c9                   | leave               
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81c420ffffff         | add                 esp, 0xffffff20
            //   ff8d6cffffff         | dec                 dword ptr [ebp - 0x94]
            //   8365dc34             | and                 dword ptr [ebp - 0x24], 0x34

        $sequence_9 = { e8???????? c9 c20800 55 8bec 81c478ffffff ff4dc0 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   c9                   | leave               
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81c478ffffff         | add                 esp, 0xffffff78
            //   ff4dc0               | dec                 dword ptr [ebp - 0x40]

    condition:
        7 of them and filesize < 843776
}