rule win_ziyangrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ziyangrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ziyangrat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2bd3 7506 41 83f912 7ce2 3bcf 7eaf }
            // n = 7, score = 200
            //   2bd3                 | sub                 edx, ebx
            //   7506                 | jne                 8
            //   41                   | inc                 ecx
            //   83f912               | cmp                 ecx, 0x12
            //   7ce2                 | jl                  0xffffffe4
            //   3bcf                 | cmp                 ecx, edi
            //   7eaf                 | jle                 0xffffffb1

        $sequence_1 = { 3d204e0000 0f8f210b0000 ffd5 2bc6 3df4010000 7e95 ffd5 }
            // n = 7, score = 200
            //   3d204e0000           | cmp                 eax, 0x4e20
            //   0f8f210b0000         | jg                  0xb27
            //   ffd5                 | call                ebp
            //   2bc6                 | sub                 eax, esi
            //   3df4010000           | cmp                 eax, 0x1f4
            //   7e95                 | jle                 0xffffff97
            //   ffd5                 | call                ebp

        $sequence_2 = { 66a5 f7d3 53 a4 e8???????? 8d7c2410 83c9ff }
            // n = 7, score = 200
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   f7d3                 | not                 ebx
            //   53                   | push                ebx
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   e8????????           |                     
            //   8d7c2410             | lea                 edi, [esp + 0x10]
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_3 = { c644240800 f3ab 66ab aa 8bbc2410040000 85ff }
            // n = 6, score = 200
            //   c644240800           | mov                 byte ptr [esp + 8], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8bbc2410040000       | mov                 edi, dword ptr [esp + 0x410]
            //   85ff                 | test                edi, edi

        $sequence_4 = { ff15???????? 8a0d???????? a1???????? 33d2 891d???????? }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   8a0d????????         |                     
            //   a1????????           |                     
            //   33d2                 | xor                 edx, edx
            //   891d????????         |                     

        $sequence_5 = { 50 6801010000 e8???????? 8bce c1e106 8d540c5c 52 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   6801010000           | push                0x101
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   c1e106               | shl                 ecx, 6
            //   8d540c5c             | lea                 edx, [esp + ecx + 0x5c]
            //   52                   | push                edx

        $sequence_6 = { 49 8bf9 8b4c2464 41 83f91a 894c2464 0f825effffff }
            // n = 7, score = 200
            //   49                   | dec                 ecx
            //   8bf9                 | mov                 edi, ecx
            //   8b4c2464             | mov                 ecx, dword ptr [esp + 0x64]
            //   41                   | inc                 ecx
            //   83f91a               | cmp                 ecx, 0x1a
            //   894c2464             | mov                 dword ptr [esp + 0x64], ecx
            //   0f825effffff         | jb                  0xffffff64

        $sequence_7 = { 7407 8b4c2424 880429 45 8887244d4100 47 81e7ff0f0000 }
            // n = 7, score = 200
            //   7407                 | je                  9
            //   8b4c2424             | mov                 ecx, dword ptr [esp + 0x24]
            //   880429               | mov                 byte ptr [ecx + ebp], al
            //   45                   | inc                 ebp
            //   8887244d4100         | mov                 byte ptr [edi + 0x414d24], al
            //   47                   | inc                 edi
            //   81e7ff0f0000         | and                 edi, 0xfff

        $sequence_8 = { c64424534f c644245455 c644245644 c64424572e c64424580d }
            // n = 5, score = 200
            //   c64424534f           | mov                 byte ptr [esp + 0x53], 0x4f
            //   c644245455           | mov                 byte ptr [esp + 0x54], 0x55
            //   c644245644           | mov                 byte ptr [esp + 0x56], 0x44
            //   c64424572e           | mov                 byte ptr [esp + 0x57], 0x2e
            //   c64424580d           | mov                 byte ptr [esp + 0x58], 0xd

        $sequence_9 = { 85c0 0f84dd000000 8b44241c 3bc3 7634 8d4c241c }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   0f84dd000000         | je                  0xe3
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   3bc3                 | cmp                 eax, ebx
            //   7634                 | jbe                 0x36
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]

    condition:
        7 of them and filesize < 188416
}