rule osx_laoshu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.laoshu"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 48 8b35???????? 49 63cc }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   8b35????????         |                     
            //   49                   | dec                 ecx
            //   63cc                 | arpl                sp, cx

        $sequence_1 = { 75cd 803b3d 74d8 83fe01 75d3 }
            // n = 5, score = 100
            //   75cd                 | jne                 0xffffffcf
            //   803b3d               | cmp                 byte ptr [ebx], 0x3d
            //   74d8                 | je                  0xffffffda
            //   83fe01               | cmp                 esi, 1
            //   75d3                 | jne                 0xffffffd5

        $sequence_2 = { 63cc 48 89c7 4c 89f2 ff15???????? }
            // n = 6, score = 100
            //   63cc                 | arpl                sp, cx
            //   48                   | dec                 eax
            //   89c7                 | mov                 edi, eax
            //   4c                   | dec                 esp
            //   89f2                 | mov                 edx, esi
            //   ff15????????         |                     

        $sequence_3 = { 01c2 83e2fc 89c6 29d6 48 }
            // n = 5, score = 100
            //   01c2                 | add                 edx, eax
            //   83e2fc               | and                 edx, 0xfffffffc
            //   89c6                 | mov                 esi, eax
            //   29d6                 | sub                 esi, edx
            //   48                   | dec                 eax

        $sequence_4 = { 48 ffc3 41 89d7 48 0fbe7bff 48 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   ffc3                 | inc                 ebx
            //   41                   | inc                 ecx
            //   89d7                 | mov                 edi, edx
            //   48                   | dec                 eax
            //   0fbe7bff             | movsx               edi, byte ptr [ebx - 1]
            //   48                   | dec                 eax

        $sequence_5 = { 4c 89f7 e8???????? 31db e9???????? 89f1 49 }
            // n = 7, score = 100
            //   4c                   | dec                 esp
            //   89f7                 | mov                 edi, esi
            //   e8????????           |                     
            //   31db                 | xor                 ebx, ebx
            //   e9????????           |                     
            //   89f1                 | mov                 ecx, esi
            //   49                   | dec                 ecx

        $sequence_6 = { 48 ffc3 eb16 41 0fbf3c79 83fffe }
            // n = 6, score = 100
            //   48                   | dec                 eax
            //   ffc3                 | inc                 ebx
            //   eb16                 | jmp                 0x18
            //   41                   | inc                 ecx
            //   0fbf3c79             | movsx               edi, word ptr [ecx + edi*2]
            //   83fffe               | cmp                 edi, -2

        $sequence_7 = { 0fbe7bff 48 85ff 0f84a3000000 }
            // n = 4, score = 100
            //   0fbe7bff             | movsx               edi, byte ptr [ebx - 1]
            //   48                   | dec                 eax
            //   85ff                 | test                edi, edi
            //   0f84a3000000         | je                  0xa9

        $sequence_8 = { 80ff3d 75cd 803b3d 74d8 83fe01 75d3 4c }
            // n = 7, score = 100
            //   80ff3d               | cmp                 bh, 0x3d
            //   75cd                 | jne                 0xffffffcf
            //   803b3d               | cmp                 byte ptr [ebx], 0x3d
            //   74d8                 | je                  0xffffffda
            //   83fe01               | cmp                 esi, 1
            //   75d3                 | jne                 0xffffffd5
            //   4c                   | dec                 esp

        $sequence_9 = { 75bd 48 ffc3 41 89d7 }
            // n = 5, score = 100
            //   75bd                 | jne                 0xffffffbf
            //   48                   | dec                 eax
            //   ffc3                 | inc                 ebx
            //   41                   | inc                 ecx
            //   89d7                 | mov                 edi, edx

    condition:
        7 of them and filesize < 86144
}