rule osx_proton_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/osx.proton_rat"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89c6 48 8b85d8feffff 48 898548ffffff 48 8b3d???????? }
            // n = 7, score = 200
            //   89c6                 | mov                 esi, eax
            //   48                   | dec                 eax
            //   8b85d8feffff         | mov                 eax, dword ptr [ebp - 0x128]
            //   48                   | dec                 eax
            //   898548ffffff         | mov                 dword ptr [ebp - 0xb8], eax
            //   48                   | dec                 eax
            //   8b3d????????         |                     

        $sequence_1 = { 8b8508ffffff 4a 8b1ce0 48 89df 48 }
            // n = 6, score = 200
            //   8b8508ffffff         | mov                 eax, dword ptr [ebp - 0xf8]
            //   4a                   | dec                 edx
            //   8b1ce0               | mov                 ebx, dword ptr [eax]
            //   48                   | dec                 eax
            //   89df                 | mov                 edi, ebx
            //   48                   | dec                 eax

        $sequence_2 = { 8bb5e0faffff 48 c785c0fbffff00000000 c785bcfbffff00000000 48 8d53ec 48 }
            // n = 7, score = 200
            //   8bb5e0faffff         | mov                 esi, dword ptr [ebp - 0x520]
            //   48                   | dec                 eax
            //   c785c0fbffff00000000     | mov    dword ptr [ebp - 0x440], 0
            //   c785bcfbffff00000000     | mov    dword ptr [ebp - 0x444], 0
            //   48                   | dec                 eax
            //   8d53ec               | lea                 edx, [ebx - 0x14]
            //   48                   | dec                 eax

        $sequence_3 = { ffd6 48 8b7da8 41 ffd6 48 8b7dd0 }
            // n = 7, score = 200
            //   ffd6                 | call                esi
            //   48                   | dec                 eax
            //   8b7da8               | mov                 edi, dword ptr [ebp - 0x58]
            //   41                   | inc                 ecx
            //   ffd6                 | call                esi
            //   48                   | dec                 eax
            //   8b7dd0               | mov                 edi, dword ptr [ebp - 0x30]

        $sequence_4 = { 8d9534fefeff 48 89de e8???????? 85c0 0f8549060000 48 }
            // n = 7, score = 200
            //   8d9534fefeff         | lea                 edx, [ebp - 0x101cc]
            //   48                   | dec                 eax
            //   89de                 | mov                 esi, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8549060000         | jne                 0x64f
            //   48                   | dec                 eax

        $sequence_5 = { 8d8d90feffff 41 ffd5 48 89c7 e8???????? 49 }
            // n = 7, score = 200
            //   8d8d90feffff         | lea                 ecx, [ebp - 0x170]
            //   41                   | inc                 ecx
            //   ffd5                 | call                ebp
            //   48                   | dec                 eax
            //   89c7                 | mov                 edi, eax
            //   e8????????           |                     
            //   49                   | dec                 ecx

        $sequence_6 = { 660f3800cb 660fefc4 6641 0f6f6240 660fefc1 6641 0f6f4a50 }
            // n = 7, score = 200
            //   660f3800cb           | pshufb              xmm1, xmm3
            //   660fefc4             | pxor                xmm0, xmm4
            //   6641                 | inc                 cx
            //   0f6f6240             | movq                mm4, qword ptr [edx + 0x40]
            //   660fefc1             | pxor                xmm0, xmm1
            //   6641                 | inc                 cx
            //   0f6f4a50             | movq                mm1, qword ptr [edx + 0x50]

        $sequence_7 = { 48 85db 48 89df 75f0 49 c7450800000000 }
            // n = 7, score = 200
            //   48                   | dec                 eax
            //   85db                 | test                ebx, ebx
            //   48                   | dec                 eax
            //   89df                 | mov                 edi, ebx
            //   75f0                 | jne                 0xfffffff2
            //   49                   | dec                 ecx
            //   c7450800000000       | mov                 dword ptr [ebp + 8], 0

        $sequence_8 = { 6644 0fefc0 660f38ded9 6644 0fefc8 0f100401 48 }
            // n = 7, score = 200
            //   6644                 | inc                 sp
            //   0fefc0               | pxor                mm0, mm0
            //   660f38ded9           | aesdec              xmm3, xmm1
            //   6644                 | inc                 sp
            //   0fefc8               | pxor                mm1, mm0
            //   0f100401             | movups              xmm0, xmmword ptr [ecx + eax]
            //   48                   | dec                 eax

        $sequence_9 = { 89c3 48 85db 7429 48 8b05???????? 4c }
            // n = 7, score = 200
            //   89c3                 | mov                 ebx, eax
            //   48                   | dec                 eax
            //   85db                 | test                ebx, ebx
            //   7429                 | je                  0x2b
            //   48                   | dec                 eax
            //   8b05????????         |                     
            //   4c                   | dec                 esp

    condition:
        7 of them and filesize < 1711568
}