rule win_9002_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.9002."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.9002"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc2 2d00040000 f7d8 1bc0 }
            // n = 4, score = 300
            //   8bc2                 | mov                 eax, edx
            //   2d00040000           | sub                 eax, 0x400
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax

        $sequence_1 = { 33c9 894808 894810 8910 c7400c01000000 894814 }
            // n = 6, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   894810               | mov                 dword ptr [eax + 0x10], ecx
            //   8910                 | mov                 dword ptr [eax], edx
            //   c7400c01000000       | mov                 dword ptr [eax + 0xc], 1
            //   894814               | mov                 dword ptr [eax + 0x14], ecx

        $sequence_2 = { 56 89442418 ff15???????? a820 }
            // n = 4, score = 200
            //   56                   | push                esi
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   ff15????????         |                     
            //   a820                 | test                al, 0x20

        $sequence_3 = { e8???????? 83c408 894604 03c5 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   03c5                 | add                 eax, ebp

        $sequence_4 = { eb04 2bc8 8be9 53 50 }
            // n = 5, score = 200
            //   eb04                 | jmp                 6
            //   2bc8                 | sub                 ecx, eax
            //   8be9                 | mov                 ebp, ecx
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_5 = { 8b460c 40 33d2 f77614 ff4610 }
            // n = 5, score = 200
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]
            //   40                   | inc                 eax
            //   33d2                 | xor                 edx, edx
            //   f77614               | div                 dword ptr [esi + 0x14]
            //   ff4610               | inc                 dword ptr [esi + 0x10]

        $sequence_6 = { ff15???????? 81c600040000 50 56 ff15???????? }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   81c600040000         | add                 esi, 0x400
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_7 = { 8b5d0c 6bdb08 03c3 8b00 }
            // n = 4, score = 200
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   6bdb08               | imul                ebx, ebx, 8
            //   03c3                 | add                 eax, ebx
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_8 = { 6a02 6a03 6a00 e8???????? }
            // n = 4, score = 200
            //   6a02                 | push                2
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   e8????????           |                     

        $sequence_9 = { 6a02 ff15???????? 68???????? ff15???????? 6a00 6a00 6a00 }
            // n = 7, score = 200
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_10 = { 68???????? ff15???????? 6a0a ff15???????? e9???????? }
            // n = 5, score = 200
            //   68????????           |                     
            //   ff15????????         |                     
            //   6a0a                 | push                0xa
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_11 = { 8bf1 50 6801020000 c706???????? e8???????? }
            // n = 5, score = 200
            //   8bf1                 | mov                 esi, ecx
            //   50                   | push                eax
            //   6801020000           | push                0x201
            //   c706????????         |                     
            //   e8????????           |                     

        $sequence_12 = { e8???????? 50 e8???????? 6a08 e8???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a08                 | push                8
            //   e8????????           |                     

        $sequence_13 = { 7504 33d2 eb05 8b5608 2bd0 3bfa }
            // n = 6, score = 200
            //   7504                 | jne                 6
            //   33d2                 | xor                 edx, edx
            //   eb05                 | jmp                 7
            //   8b5608               | mov                 edx, dword ptr [esi + 8]
            //   2bd0                 | sub                 edx, eax
            //   3bfa                 | cmp                 edi, edx

        $sequence_14 = { 83b98c00000002 7504 33c9 eb03 8b4914 }
            // n = 5, score = 200
            //   83b98c00000002       | cmp                 dword ptr [ecx + 0x8c], 2
            //   7504                 | jne                 6
            //   33c9                 | xor                 ecx, ecx
            //   eb03                 | jmp                 5
            //   8b4914               | mov                 ecx, dword ptr [ecx + 0x14]

        $sequence_15 = { 33c9 3bc8 1bd2 f7da 8915???????? }
            // n = 5, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   3bc8                 | cmp                 ecx, eax
            //   1bd2                 | sbb                 edx, edx
            //   f7da                 | neg                 edx
            //   8915????????         |                     

        $sequence_16 = { 894814 89481c c20400 56 8bf1 }
            // n = 5, score = 200
            //   894814               | mov                 dword ptr [eax + 0x14], ecx
            //   89481c               | mov                 dword ptr [eax + 0x1c], ecx
            //   c20400               | ret                 4
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx

        $sequence_17 = { 03c3 8b00 5b ffd0 }
            // n = 4, score = 200
            //   03c3                 | add                 eax, ebx
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   5b                   | pop                 ebx
            //   ffd0                 | call                eax

        $sequence_18 = { 80e108 0ac8 80c910 880e 8ac2 }
            // n = 5, score = 200
            //   80e108               | and                 cl, 8
            //   0ac8                 | or                  cl, al
            //   80c910               | or                  cl, 0x10
            //   880e                 | mov                 byte ptr [esi], cl
            //   8ac2                 | mov                 al, dl

        $sequence_19 = { 51 e8???????? 6a06 6a01 6a02 e8???????? }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   e8????????           |                     
            //   6a06                 | push                6
            //   6a01                 | push                1
            //   6a02                 | push                2
            //   e8????????           |                     

        $sequence_20 = { 8806 46 c1ea06 8816 46 }
            // n = 5, score = 200
            //   8806                 | mov                 byte ptr [esi], al
            //   46                   | inc                 esi
            //   c1ea06               | shr                 edx, 6
            //   8816                 | mov                 byte ptr [esi], dl
            //   46                   | inc                 esi

        $sequence_21 = { 8b01 ff5010 8b7614 ff4e0c 5e }
            // n = 5, score = 200
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff5010               | call                dword ptr [eax + 0x10]
            //   8b7614               | mov                 esi, dword ptr [esi + 0x14]
            //   ff4e0c               | dec                 dword ptr [esi + 0xc]
            //   5e                   | pop                 esi

        $sequence_22 = { 742e 85f6 7419 0fb6da f683c1d4001004 7406 8816 }
            // n = 7, score = 100
            //   742e                 | je                  0x30
            //   85f6                 | test                esi, esi
            //   7419                 | je                  0x1b
            //   0fb6da               | movzx               ebx, dl
            //   f683c1d4001004       | test                byte ptr [ebx + 0x1000d4c1], 4
            //   7406                 | je                  8
            //   8816                 | mov                 byte ptr [esi], dl

        $sequence_23 = { 64a300000000 8bf9 8d7708 8bce }
            // n = 4, score = 100
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf9                 | mov                 edi, ecx
            //   8d7708               | lea                 esi, [edi + 8]
            //   8bce                 | mov                 ecx, esi

        $sequence_24 = { e8???????? 83c43c c21000 56 e8???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c43c               | add                 esp, 0x3c
            //   c21000               | ret                 0x10
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_25 = { 6689bc5a80010000 83c30c 895c2424 e9???????? }
            // n = 4, score = 100
            //   6689bc5a80010000     | mov                 word ptr [edx + ebx*2 + 0x180], di
            //   83c30c               | add                 ebx, 0xc
            //   895c2424             | mov                 dword ptr [esp + 0x24], ebx
            //   e9????????           |                     

        $sequence_26 = { 8d4c240c 8d542418 6a05 8944241c 51 }
            // n = 5, score = 100
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   8d542418             | lea                 edx, [esp + 0x18]
            //   6a05                 | push                5
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   51                   | push                ecx

        $sequence_27 = { ff15???????? 8bc6 8b4c2434 64890d00000000 59 5f }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8bc6                 | mov                 eax, esi
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi

        $sequence_28 = { 03c2 eb02 33c0 85ff }
            // n = 4, score = 100
            //   03c2                 | add                 eax, edx
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   85ff                 | test                edi, edi

        $sequence_29 = { 8bf8 6a40 6800100000 57 6a00 ff15???????? 8d4df8 }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   6a40                 | push                0x40
            //   6800100000           | push                0x1000
            //   57                   | push                edi
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8d4df8               | lea                 ecx, [ebp - 8]

        $sequence_30 = { c7470400000000 2504400080 5f 40 5e c3 5f }
            // n = 7, score = 100
            //   c7470400000000       | mov                 dword ptr [edi + 4], 0
            //   2504400080           | and                 eax, 0x80004004
            //   5f                   | pop                 edi
            //   40                   | inc                 eax
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   5f                   | pop                 edi

        $sequence_31 = { 7622 8b4558 83f805 7316 8a0b }
            // n = 5, score = 100
            //   7622                 | jbe                 0x24
            //   8b4558               | mov                 eax, dword ptr [ebp + 0x58]
            //   83f805               | cmp                 eax, 5
            //   7316                 | jae                 0x18
            //   8a0b                 | mov                 cl, byte ptr [ebx]

        $sequence_32 = { 8b5c247c 55 56 8bb4248c000000 57 8b3b 8b2e }
            // n = 7, score = 100
            //   8b5c247c             | mov                 ebx, dword ptr [esp + 0x7c]
            //   55                   | push                ebp
            //   56                   | push                esi
            //   8bb4248c000000       | mov                 esi, dword ptr [esp + 0x8c]
            //   57                   | push                edi
            //   8b3b                 | mov                 edi, dword ptr [ebx]
            //   8b2e                 | mov                 ebp, dword ptr [esi]

        $sequence_33 = { ff15???????? 015e18 57 83561c00 ff15???????? 5b }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   015e18               | add                 dword ptr [esi + 0x18], ebx
            //   57                   | push                edi
            //   83561c00             | adc                 dword ptr [esi + 0x1c], 0
            //   ff15????????         |                     
            //   5b                   | pop                 ebx

        $sequence_34 = { 8bf1 e8???????? 8be8 83c608 8bce }
            // n = 5, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   8be8                 | mov                 ebp, eax
            //   83c608               | add                 esi, 8
            //   8bce                 | mov                 ecx, esi

        $sequence_35 = { c3 b8???????? c705????????772b0010 a3???????? }
            // n = 4, score = 100
            //   c3                   | ret                 
            //   b8????????           |                     
            //   c705????????772b0010     |     
            //   a3????????           |                     

        $sequence_36 = { ff15???????? 8bf8 6a40 6800100000 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   6a40                 | push                0x40
            //   6800100000           | push                0x1000

        $sequence_37 = { 7548 8b4e0c 394f0c 7540 8b5748 807f040a }
            // n = 6, score = 100
            //   7548                 | jne                 0x4a
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]
            //   394f0c               | cmp                 dword ptr [edi + 0xc], ecx
            //   7540                 | jne                 0x42
            //   8b5748               | mov                 edx, dword ptr [edi + 0x48]
            //   807f040a             | cmp                 byte ptr [edi + 4], 0xa

    condition:
        7 of them and filesize < 204800
}