rule win_alpc_lpe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.alpc_lpe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alpc_lpe"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 4883ec28 488d6a20 4533c0 b201 488b8d50010000 e8???????? }
            // n = 7, score = 100
            //   57                   | lea                 edx, [0xf589]
            //   4883ec28             | mov                 ecx, 2
            //   488d6a20             | dec                 eax
            //   4533c0               | mov                 dword ptr [esp + 0x28], eax
            //   b201                 | dec                 eax
            //   488b8d50010000       | lea                 eax, [0xf899]
            //   e8????????           |                     

        $sequence_1 = { 488d0d50830000 33d2 e8???????? 488bf8 4885c0 7507 }
            // n = 6, score = 100
            //   488d0d50830000       | xor                 ecx, ecx
            //   33d2                 | inc                 ecx
            //   e8????????           |                     
            //   488bf8               | mov                 eax, 0x84
            //   4885c0               | dec                 eax
            //   7507                 | lea                 edx, [0xf809]

        $sequence_2 = { e8???????? 4885c0 0f85ce000000 488d15cfa90000 488bcb e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   4885c0               | jmp                 4
            //   0f85ce000000         | dec                 eax
            //   488d15cfa90000       | lea                 eax, [0x8938]
            //   488bcb               | dec                 eax
            //   e8????????           |                     

        $sequence_3 = { 488bc1 488b8d18010000 48894c2428 488b8d10010000 48894c2420 4c8b8d08010000 4c8b8500010000 }
            // n = 7, score = 100
            //   488bc1               | dec                 eax
            //   488b8d18010000       | lea                 ecx, [0xae69]
            //   48894c2428           | dec                 eax
            //   488b8d10010000       | lea                 ecx, [0xae4d]
            //   48894c2420           | dec                 eax
            //   4c8b8d08010000       | lea                 ecx, [0xb168]
            //   4c8b8500010000       | dec                 eax

        $sequence_4 = { 48837d0801 770d 48c785f800000001000000 eb0e 488b4508 48ffc8 488985f8000000 }
            // n = 7, score = 100
            //   48837d0801           | dec                 eax
            //   770d                 | mov                 dword ptr [ebp + 8], eax
            //   48c785f800000001000000     | mov    eax, dword ptr [ebp + 8]
            //   eb0e                 | dec                 esp
            //   488b4508             | mov                 eax, dword ptr [ebp + 0x100]
            //   48ffc8               | dec                 eax
            //   488985f8000000       | mov                 edx, eax

        $sequence_5 = { 90 488d4d08 e8???????? 0fb685c4020000 488bf8 488d4dd0 488d15f3d40000 }
            // n = 7, score = 100
            //   90                   | mov                 ecx, ebx
            //   488d4d08             | dec                 eax
            //   e8????????           |                     
            //   0fb685c4020000       | mov                 ecx, ebx
            //   488bf8               | dec                 eax
            //   488d4dd0             | lea                 edx, [0xb823]
            //   488d15f3d40000       | cmp                 eax, esi

        $sequence_6 = { 4c8d05cbfa0000 488d1574fb0000 488d0d95fb0000 ff15???????? 486b856801000010 }
            // n = 5, score = 100
            //   4c8d05cbfa0000       | mov                 ecx, dword ptr [ebp + 0x120]
            //   488d1574fb0000       | dec                 eax
            //   488d0d95fb0000       | mov                 ecx, dword ptr [ebp + 0x120]
            //   ff15????????         |                     
            //   486b856801000010     | dec                 eax

        $sequence_7 = { 488bd0 488d4d04 e8???????? 488b8d00010000 }
            // n = 4, score = 100
            //   488bd0               | mov                 dword ptr [ebp + 0x118], eax
            //   488d4d04             | dec                 eax
            //   e8????????           |                     
            //   488b8d00010000       | mov                 ecx, dword ptr [ebp + 0x150]

        $sequence_8 = { 488b8d20010000 e8???????? 488b8d28010000 488d0448 48894508 488b8d20010000 }
            // n = 6, score = 100
            //   488b8d20010000       | mov                 dword ptr [ebp + 0x48], eax
            //   e8????????           |                     
            //   488b8d28010000       | dec                 eax
            //   488d0448             | mov                 eax, dword ptr [ebp + 0x28]
            //   48894508             | dec                 eax
            //   488b8d20010000       | cmp                 dword ptr [ebp + 0x48], eax

        $sequence_9 = { 4c8d4dbf 33d2 4c8d05cc7e0000 488bcf ffd3 85c0 }
            // n = 6, score = 100
            //   4c8d4dbf             | mov                 eax, dword ptr [eax]
            //   33d2                 | dec                 eax
            //   4c8d05cc7e0000       | mov                 dword ptr [eax + 8], 0
            //   488bcf               | dec                 eax
            //   ffd3                 | lea                 ecx, [ebp + 4]
            //   85c0                 | dec                 eax

    condition:
        7 of them and filesize < 540672
}