rule win_arik_keylogger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.arik_keylogger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.arik_keylogger"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8064040000 85c0 7468 8b45fc 8b8064040000 e8???????? 89c3 }
            // n = 7, score = 200
            //   8b8064040000         | mov                 eax, dword ptr [eax + 0x464]
            //   85c0                 | test                eax, eax
            //   7468                 | je                  0x6a
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b8064040000         | mov                 eax, dword ptr [eax + 0x464]
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax

        $sequence_1 = { ff4008 8b45fc ff40f0 e8???????? 8d45c0 e8???????? c745c000000000 }
            // n = 7, score = 200
            //   ff4008               | inc                 dword ptr [eax + 8]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   ff40f0               | inc                 dword ptr [eax - 0x10]
            //   e8????????           |                     
            //   8d45c0               | lea                 eax, [ebp - 0x40]
            //   e8????????           |                     
            //   c745c000000000       | mov                 dword ptr [ebp - 0x40], 0

        $sequence_2 = { 8d85fcfdffff 89da e8???????? 85c0 750c c745fc12000000 e9???????? }
            // n = 7, score = 200
            //   8d85fcfdffff         | lea                 eax, [ebp - 0x204]
            //   89da                 | mov                 edx, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   c745fc12000000       | mov                 dword ptr [ebp - 4], 0x12
            //   e9????????           |                     

        $sequence_3 = { 8d9574ffffff b801000000 e8???????? e8???????? 50 85c0 0f8576010000 }
            // n = 7, score = 200
            //   8d9574ffffff         | lea                 edx, [ebp - 0x8c]
            //   b801000000           | mov                 eax, 1
            //   e8????????           |                     
            //   e8????????           |                     
            //   50                   | push                eax
            //   85c0                 | test                eax, eax
            //   0f8576010000         | jne                 0x17c

        $sequence_4 = { ff75f0 a1???????? ffd0 8b45f4 83c060 b100 ba10000000 }
            // n = 7, score = 200
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   a1????????           |                     
            //   ffd0                 | call                eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83c060               | add                 eax, 0x60
            //   b100                 | mov                 cl, 0
            //   ba10000000           | mov                 edx, 0x10

        $sequence_5 = { c3 55 89e5 83ec04 a1???????? 8945fc 8b45fc }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   83ec04               | sub                 esp, 4
            //   a1????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_6 = { c745f800000000 58 85c0 7405 e8???????? 8b5dc8 8b75cc }
            // n = 7, score = 200
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   58                   | pop                 eax
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   e8????????           |                     
            //   8b5dc8               | mov                 ebx, dword ptr [ebp - 0x38]
            //   8b75cc               | mov                 esi, dword ptr [ebp - 0x34]

        $sequence_7 = { 8b85b8feffff 8945f0 e8???????? 89c3 8d55e8 89d8 8b0b }
            // n = 7, score = 200
            //   8b85b8feffff         | mov                 eax, dword ptr [ebp - 0x148]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax
            //   8d55e8               | lea                 edx, [ebp - 0x18]
            //   89d8                 | mov                 eax, ebx
            //   8b0b                 | mov                 ecx, dword ptr [ebx]

        $sequence_8 = { 8b8064040000 8945f4 8b45fc 8b407c 85c0 7434 814df800000200 }
            // n = 7, score = 200
            //   8b8064040000         | mov                 eax, dword ptr [eax + 0x464]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b407c               | mov                 eax, dword ptr [eax + 0x7c]
            //   85c0                 | test                eax, eax
            //   7434                 | je                  0x36
            //   814df800000200       | or                  dword ptr [ebp - 8], 0x20000

        $sequence_9 = { eb60 8b45fc 8b40fc 8b4060 ff30 8b45fc 8b40fc }
            // n = 7, score = 200
            //   eb60                 | jmp                 0x62
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b40fc               | mov                 eax, dword ptr [eax - 4]
            //   8b4060               | mov                 eax, dword ptr [eax + 0x60]
            //   ff30                 | push                dword ptr [eax]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b40fc               | mov                 eax, dword ptr [eax - 4]

    condition:
        7 of them and filesize < 4947968
}