rule win_avrecon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.avrecon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.avrecon"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7431 6810270000 ff15???????? 837d0400 7420 }
            // n = 6, score = 300
            //   85c0                 | test                eax, eax
            //   7431                 | je                  0x33
            //   6810270000           | push                0x2710
            //   ff15????????         |                     
            //   837d0400             | cmp                 dword ptr [ebp + 4], 0
            //   7420                 | je                  0x22

        $sequence_1 = { bf04010000 57 53 53 56 55 ff15???????? }
            // n = 7, score = 300
            //   bf04010000           | mov                 edi, 0x104
            //   57                   | push                edi
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   56                   | push                esi
            //   55                   | push                ebp
            //   ff15????????         |                     

        $sequence_2 = { e8???????? 8bf8 85ff 741f 56 8b35???????? 68???????? }
            // n = 7, score = 300
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   741f                 | je                  0x21
            //   56                   | push                esi
            //   8b35????????         |                     
            //   68????????           |                     

        $sequence_3 = { 6a10 6a00 8d45dc 50 e8???????? 8d45f0 }
            // n = 6, score = 300
            //   6a10                 | push                0x10
            //   6a00                 | push                0
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]

        $sequence_4 = { c21000 33c0 ebf5 83c8ff ebf0 55 8bec }
            // n = 7, score = 300
            //   c21000               | ret                 0x10
            //   33c0                 | xor                 eax, eax
            //   ebf5                 | jmp                 0xfffffff7
            //   83c8ff               | or                  eax, 0xffffffff
            //   ebf0                 | jmp                 0xfffffff2
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_5 = { ebed c685dcebffff00 6a02 ff7508 ff15???????? ff7508 e8???????? }
            // n = 7, score = 300
            //   ebed                 | jmp                 0xffffffef
            //   c685dcebffff00       | mov                 byte ptr [ebp - 0x1424], 0
            //   6a02                 | push                2
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_6 = { e8???????? 68???????? 53 e8???????? 85c0 0f84f0040000 8a08 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   68????????           |                     
            //   53                   | push                ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f84f0040000         | je                  0x4f6
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_7 = { 50 8d85a8feffff 50 895d4c e8???????? 3bc3 }
            // n = 6, score = 300
            //   50                   | push                eax
            //   8d85a8feffff         | lea                 eax, [ebp - 0x158]
            //   50                   | push                eax
            //   895d4c               | mov                 dword ptr [ebp + 0x4c], ebx
            //   e8????????           |                     
            //   3bc3                 | cmp                 eax, ebx

        $sequence_8 = { 49 7524 50 a3???????? ff15???????? e8???????? }
            // n = 6, score = 300
            //   49                   | dec                 ecx
            //   7524                 | jne                 0x26
            //   50                   | push                eax
            //   a3????????           |                     
            //   ff15????????         |                     
            //   e8????????           |                     

        $sequence_9 = { 50 6a01 50 50 ff31 8975c0 50 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   6a01                 | push                1
            //   50                   | push                eax
            //   50                   | push                eax
            //   ff31                 | push                dword ptr [ecx]
            //   8975c0               | mov                 dword ptr [ebp - 0x40], esi
            //   50                   | push                eax

    condition:
        7 of them and filesize < 360448
}