rule win_badflick_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.badflick."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.badflick"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff35???????? 8d85ecfbffff ff35???????? 68???????? ff35???????? 68???????? 68???????? }
            // n = 7, score = 100
            //   ff35????????         |                     
            //   8d85ecfbffff         | lea                 eax, [ebp - 0x414]
            //   ff35????????         |                     
            //   68????????           |                     
            //   ff35????????         |                     
            //   68????????           |                     
            //   68????????           |                     

        $sequence_1 = { ff15???????? 85c0 0f8425010000 837dfc04 0f851b010000 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8425010000         | je                  0x12b
            //   837dfc04             | cmp                 dword ptr [ebp - 4], 4
            //   0f851b010000         | jne                 0x121

        $sequence_2 = { a5 a5 a5 e8???????? 33db 59 885d0b }
            // n = 7, score = 100
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   e8????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   59                   | pop                 ecx
            //   885d0b               | mov                 byte ptr [ebp + 0xb], bl

        $sequence_3 = { ff15???????? 8bd8 83fbff 746b 56 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   83fbff               | cmp                 ebx, -1
            //   746b                 | je                  0x6d
            //   56                   | push                esi

        $sequence_4 = { e9???????? 33db 395df8 74e2 6800800000 }
            // n = 5, score = 100
            //   e9????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   395df8               | cmp                 dword ptr [ebp - 8], ebx
            //   74e2                 | je                  0xffffffe4
            //   6800800000           | push                0x8000

        $sequence_5 = { 8bf0 68???????? 56 ff15???????? 85c0 0f85e7000000 6a01 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   68????????           |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f85e7000000         | jne                 0xed
            //   6a01                 | push                1

        $sequence_6 = { 56 ff15???????? 50 0fb706 50 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   50                   | push                eax
            //   0fb706               | movzx               eax, word ptr [esi]
            //   50                   | push                eax

        $sequence_7 = { 8d85a8fbffff 50 7408 e8???????? }
            // n = 4, score = 100
            //   8d85a8fbffff         | lea                 eax, [ebp - 0x458]
            //   50                   | push                eax
            //   7408                 | je                  0xa
            //   e8????????           |                     

        $sequence_8 = { ff7508 ff15???????? 53 ff15???????? 5f }
            // n = 5, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   5f                   | pop                 edi

        $sequence_9 = { ff15???????? 32c0 eb3e ff7510 e8???????? 8bf0 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   32c0                 | xor                 al, al
            //   eb3e                 | jmp                 0x40
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

    condition:
        7 of them and filesize < 81920
}