rule win_bahamut_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2018-11-23"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator 0.1a"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bahamut"
        malpedia_version = "20180607"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using yara-signator.
     * The code and documentation / approach will be published in the near future here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */

    strings:
        $sequence_0 = { 00e9 0300 0000 0008 }
            // n = 4, score = 1000
            //   00e9                 | add                 cl, ch
            //   0300                 | add                 eax, dword ptr [eax]
            //   0000                 | add                 byte ptr [eax], al
            //   0008                 | add                 byte ptr [eax], cl

        $sequence_1 = { 0003 10c6 0d8b0f5901 e900000000 }
            // n = 4, score = 1000
            //   0003                 | add                 byte ptr [ebx], al
            //   10c6                 | adc                 dh, al
            //   0d8b0f5901           | or                  eax, 0x1590f8b
            //   e900000000           | jmp                 0xd51fdf

        $sequence_2 = { 10c6 0d8b0f5901 e900000000 0003 }
            // n = 4, score = 1000
            //   10c6                 | adc                 dh, al
            //   0d8b0f5901           | or                  eax, 0x1590f8b
            //   e900000000           | jmp                 0xd51fdf
            //   0003                 | add                 byte ptr [ebx], al

        $sequence_3 = { 0d8b0f5901 e900000000 0003 10c6 }
            // n = 4, score = 1000
            //   0d8b0f5901           | or                  eax, 0x1590f8b
            //   e900000000           | jmp                 0xd51fdf
            //   0003                 | add                 byte ptr [ebx], al
            //   10c6                 | adc                 dh, al

        $sequence_4 = { 10c6 0d8b0f5901 e900000000 0003 10c6 }
            // n = 5, score = 1000
            //   10c6                 | adc                 dh, al
            //   0d8b0f5901           | or                  eax, 0x1590f8b
            //   e900000000           | jmp                 0xd51fdf
            //   0003                 | add                 byte ptr [ebx], al
            //   10c6                 | adc                 dh, al

        $sequence_5 = { 0003 10c6 0d8b0f5901 e900000000 0003 }
            // n = 5, score = 1000
            //   0003                 | add                 byte ptr [ebx], al
            //   10c6                 | adc                 dh, al
            //   0d8b0f5901           | or                  eax, 0x1590f8b
            //   e900000000           | jmp                 0xd51fdf
            //   0003                 | add                 byte ptr [ebx], al

        $sequence_6 = { 0003 10c6 0d8b0f5901 e900000000 0003 10c6 }
            // n = 6, score = 1000
            //   0003                 | add                 byte ptr [ebx], al
            //   10c6                 | adc                 dh, al
            //   0d8b0f5901           | or                  eax, 0x1590f8b
            //   e900000000           | jmp                 0xd51fdf
            //   0003                 | add                 byte ptr [ebx], al
            //   10c6                 | adc                 dh, al

    condition:
        7 of them
}