rule win_bandook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bandook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bandook"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 752d ff35???????? 8b3e 8d4598 8b7604 68???????? }
            // n = 7, score = 100
            //   57                   | push                edi
            //   752d                 | jne                 0x2f
            //   ff35????????         |                     
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   8d4598               | lea                 eax, [ebp - 0x68]
            //   8b7604               | mov                 esi, dword ptr [esi + 4]
            //   68????????           |                     

        $sequence_1 = { 8945f8 8b4508 53 8b1d???????? 56 8b08 8b4004 }
            // n = 7, score = 100
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   53                   | push                ebx
            //   8b1d????????         |                     
            //   56                   | push                esi
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]

        $sequence_2 = { 0f84e0000000 b8???????? 8d4c243c 660f1f440000 8a11 3a10 751a }
            // n = 7, score = 100
            //   0f84e0000000         | je                  0xe6
            //   b8????????           |                     
            //   8d4c243c             | lea                 ecx, [esp + 0x3c]
            //   660f1f440000         | nop                 word ptr [eax + eax]
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   3a10                 | cmp                 dl, byte ptr [eax]
            //   751a                 | jne                 0x1c

        $sequence_3 = { 8b550c 83ec20 33c9 8bc1 3914c590051d13 7408 40 }
            // n = 7, score = 100
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   83ec20               | sub                 esp, 0x20
            //   33c9                 | xor                 ecx, ecx
            //   8bc1                 | mov                 eax, ecx
            //   3914c590051d13       | cmp                 dword ptr [eax*8 + 0x131d0590], edx
            //   7408                 | je                  0xa
            //   40                   | inc                 eax

        $sequence_4 = { 3bf3 720e 4e 42 0fb606 80b830841e1300 74e9 }
            // n = 7, score = 100
            //   3bf3                 | cmp                 esi, ebx
            //   720e                 | jb                  0x10
            //   4e                   | dec                 esi
            //   42                   | inc                 edx
            //   0fb606               | movzx               eax, byte ptr [esi]
            //   80b830841e1300       | cmp                 byte ptr [eax + 0x131e8430], 0
            //   74e9                 | je                  0xffffffeb

        $sequence_5 = { 238890bb1e13 03c5 3d00080000 72f1 230d???????? 094c2424 094c2428 }
            // n = 7, score = 100
            //   238890bb1e13         | and                 ecx, dword ptr [eax + 0x131ebb90]
            //   03c5                 | add                 eax, ebp
            //   3d00080000           | cmp                 eax, 0x800
            //   72f1                 | jb                  0xfffffff3
            //   230d????????         |                     
            //   094c2424             | or                  dword ptr [esp + 0x24], ecx
            //   094c2428             | or                  dword ptr [esp + 0x28], ecx

        $sequence_6 = { ba???????? b9???????? 8d85f4fbffff 0f45ca 51 68???????? 68???????? }
            // n = 7, score = 100
            //   ba????????           |                     
            //   b9????????           |                     
            //   8d85f4fbffff         | lea                 eax, [ebp - 0x40c]
            //   0f45ca               | cmovne              ecx, edx
            //   51                   | push                ecx
            //   68????????           |                     
            //   68????????           |                     

        $sequence_7 = { 8b0d???????? a3???????? 894c2414 85c9 0f846b010000 6a10 8d4c2414 }
            // n = 7, score = 100
            //   8b0d????????         |                     
            //   a3????????           |                     
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   85c9                 | test                ecx, ecx
            //   0f846b010000         | je                  0x171
            //   6a10                 | push                0x10
            //   8d4c2414             | lea                 ecx, [esp + 0x14]

        $sequence_8 = { ff15???????? 68???????? 8d85d0feffff 50 ff15???????? 8d8550faffff c78564faffff00000000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   68????????           |                     
            //   8d85d0feffff         | lea                 eax, [ebp - 0x130]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d8550faffff         | lea                 eax, [ebp - 0x5b0]
            //   c78564faffff00000000     | mov    dword ptr [ebp - 0x59c], 0

        $sequence_9 = { c60000 0f57c0 660fd64704 8d45a4 c645fc03 50 8d4f10 }
            // n = 7, score = 100
            //   c60000               | mov                 byte ptr [eax], 0
            //   0f57c0               | xorps               xmm0, xmm0
            //   660fd64704           | movq                qword ptr [edi + 4], xmm0
            //   8d45a4               | lea                 eax, [ebp - 0x5c]
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   50                   | push                eax
            //   8d4f10               | lea                 ecx, [edi + 0x10]

    condition:
        7 of them and filesize < 23088128
}