rule win_bart_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bart."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bart"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45ff 6a01 50 53 ffd7 8a4632 8845ff }
            // n = 7, score = 100
            //   8d45ff               | lea                 eax, [ebp - 1]
            //   6a01                 | push                1
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ffd7                 | call                edi
            //   8a4632               | mov                 al, byte ptr [esi + 0x32]
            //   8845ff               | mov                 byte ptr [ebp - 1], al

        $sequence_1 = { 5f 8be5 5d c3 b8???????? e8???????? 83ec18 }
            // n = 7, score = 100
            //   5f                   | pop                 edi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   b8????????           |                     
            //   e8????????           |                     
            //   83ec18               | sub                 esp, 0x18

        $sequence_2 = { 889d78ffffff 57 8b7d10 84db 0f8ed3020000 0fb6d3 }
            // n = 6, score = 100
            //   889d78ffffff         | mov                 byte ptr [ebp - 0x88], bl
            //   57                   | push                edi
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   84db                 | test                bl, bl
            //   0f8ed3020000         | jle                 0x2d9
            //   0fb6d3               | movzx               edx, bl

        $sequence_3 = { c3 55 8bec 51 53 8b5d08 8d45ff }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8d45ff               | lea                 eax, [ebp - 1]

        $sequence_4 = { 89848e70af0400 4b 75a8 8b45f8 eb56 }
            // n = 5, score = 100
            //   89848e70af0400       | mov                 dword ptr [esi + ecx*4 + 0x4af70], eax
            //   4b                   | dec                 ebx
            //   75a8                 | jne                 0xffffffaa
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   eb56                 | jmp                 0x58

        $sequence_5 = { 56 e8???????? 8b9d68ffffff 8d45bc 50 8b87b0000000 53 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b9d68ffffff         | mov                 ebx, dword ptr [ebp - 0x98]
            //   8d45bc               | lea                 eax, [ebp - 0x44]
            //   50                   | push                eax
            //   8b87b0000000         | mov                 eax, dword ptr [edi + 0xb0]
            //   53                   | push                ebx

        $sequence_6 = { 8b45e0 59 3945d4 7596 3bde 0f841c020000 }
            // n = 6, score = 100
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   59                   | pop                 ecx
            //   3945d4               | cmp                 dword ptr [ebp - 0x2c], eax
            //   7596                 | jne                 0xffffff98
            //   3bde                 | cmp                 ebx, esi
            //   0f841c020000         | je                  0x222

        $sequence_7 = { 8d4517 885d17 50 56 ffd7 8b5df4 8d4517 }
            // n = 7, score = 100
            //   8d4517               | lea                 eax, [ebp + 0x17]
            //   885d17               | mov                 byte ptr [ebp + 0x17], bl
            //   50                   | push                eax
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   8b5df4               | mov                 ebx, dword ptr [ebp - 0xc]
            //   8d4517               | lea                 eax, [ebp + 0x17]

        $sequence_8 = { 56 53 50 6a00 57 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   53                   | push                ebx
            //   50                   | push                eax
            //   6a00                 | push                0
            //   57                   | push                edi

        $sequence_9 = { 83f819 0f84ae000000 83ff23 0f84a5000000 83fe23 0f849c000000 83f823 }
            // n = 7, score = 100
            //   83f819               | cmp                 eax, 0x19
            //   0f84ae000000         | je                  0xb4
            //   83ff23               | cmp                 edi, 0x23
            //   0f84a5000000         | je                  0xab
            //   83fe23               | cmp                 esi, 0x23
            //   0f849c000000         | je                  0xa2
            //   83f823               | cmp                 eax, 0x23

    condition:
        7 of them and filesize < 163840
}