rule win_batel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.batel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.batel"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 5b c21000 3b0d???????? }
            // n = 4, score = 200
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   c21000               | ret                 0x10
            //   3b0d????????         |                     

        $sequence_1 = { 68a00f0000 ffd5 8b1d???????? bf01000000 8d642400 68???????? }
            // n = 6, score = 100
            //   68a00f0000           | push                0xfa0
            //   ffd5                 | call                ebp
            //   8b1d????????         |                     
            //   bf01000000           | mov                 edi, 1
            //   8d642400             | lea                 esp, [esp]
            //   68????????           |                     

        $sequence_2 = { 8d642400 68???????? ff15???????? 8bf0 85f6 7422 }
            // n = 6, score = 100
            //   8d642400             | lea                 esp, [esp]
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7422                 | je                  0x24

        $sequence_3 = { 33c0 40 c20c00 55 8bec 81eca0020000 68ee020000 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81eca0020000         | sub                 esp, 0x2a0
            //   68ee020000           | push                0x2ee

        $sequence_4 = { 68d0202300 68c4202300 e8???????? 59 59 85c0 }
            // n = 6, score = 100
            //   68d0202300           | push                0x2320d0
            //   68c4202300           | push                0x2320c4
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_5 = { 750c 68c6172300 ff15???????? 59 e8???????? 833d????????ff }
            // n = 6, score = 100
            //   750c                 | jne                 0xe
            //   68c6172300           | push                0x2317c6
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   833d????????ff       |                     

        $sequence_6 = { 6a00 50 c68560fdffff00 e8???????? 83c40c 33c9 b8???????? }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   50                   | push                eax
            //   c68560fdffff00       | mov                 byte ptr [ebp - 0x2a0], 0
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   33c9                 | xor                 ecx, ecx
            //   b8????????           |                     

        $sequence_7 = { 6800002300 e8???????? 83c404 85c0 7454 }
            // n = 5, score = 100
            //   6800002300           | push                0x230000
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7454                 | je                  0x56

        $sequence_8 = { 8bec ff7514 ff7510 ff750c ff7508 6862102300 6800302300 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6862102300           | push                0x231062
            //   6800302300           | push                0x233000

        $sequence_9 = { ff15???????? 8bf8 b9a7000000 8db560fdffff f3a5 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   b9a7000000           | mov                 ecx, 0xa7
            //   8db560fdffff         | lea                 esi, [ebp - 0x2a0]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_10 = { 33c9 b8???????? 8a10 88940d60fdffff 83c003 }
            // n = 5, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   b8????????           |                     
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   88940d60fdffff       | mov                 byte ptr [ebp + ecx - 0x2a0], dl
            //   83c003               | add                 eax, 3

        $sequence_11 = { 55 8b2d???????? 56 57 68a00f0000 }
            // n = 5, score = 100
            //   55                   | push                ebp
            //   8b2d????????         |                     
            //   56                   | push                esi
            //   57                   | push                edi
            //   68a00f0000           | push                0xfa0

        $sequence_12 = { 8bec 81eca0020000 68ee020000 ff15???????? 689d020000 8d8561fdffff 6a00 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   81eca0020000         | sub                 esp, 0x2a0
            //   68ee020000           | push                0x2ee
            //   ff15????????         |                     
            //   689d020000           | push                0x29d
            //   8d8561fdffff         | lea                 eax, [ebp - 0x29f]
            //   6a00                 | push                0

        $sequence_13 = { 47 83ff5a 7ccd 5f 5e 5d }
            // n = 6, score = 100
            //   47                   | inc                 edi
            //   83ff5a               | cmp                 edi, 0x5a
            //   7ccd                 | jl                  0xffffffcf
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_14 = { 6a01 e8???????? 59 6a00 ff15???????? 68d8202300 }
            // n = 6, score = 100
            //   6a01                 | push                1
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   68d8202300           | push                0x2320d8

        $sequence_15 = { 8db560fdffff f3a5 66a5 ffd0 5f }
            // n = 5, score = 100
            //   8db560fdffff         | lea                 esi, [ebp - 0x2a0]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   ffd0                 | call                eax
            //   5f                   | pop                 edi

        $sequence_16 = { ffd0 56 ffd3 68005c2605 ffd5 }
            // n = 5, score = 100
            //   ffd0                 | call                eax
            //   56                   | push                esi
            //   ffd3                 | call                ebx
            //   68005c2605           | push                0x5265c00
            //   ffd5                 | call                ebp

        $sequence_17 = { 88940d60fdffff 83c003 41 3d???????? 7cec 56 57 }
            // n = 7, score = 100
            //   88940d60fdffff       | mov                 byte ptr [ebp + ecx - 0x2a0], dl
            //   83c003               | add                 eax, 3
            //   41                   | inc                 ecx
            //   3d????????           |                     
            //   7cec                 | jl                  0xffffffee
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_18 = { 68005c2605 ffd5 47 83ff5a }
            // n = 4, score = 100
            //   68005c2605           | push                0x5265c00
            //   ffd5                 | call                ebp
            //   47                   | inc                 edi
            //   83ff5a               | cmp                 edi, 0x5a

        $sequence_19 = { 57 6a40 6800100000 689e020000 6a00 ff15???????? 8bf8 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   6a40                 | push                0x40
            //   6800100000           | push                0x1000
            //   689e020000           | push                0x29e
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_20 = { a1???????? c704242c302300 ff35???????? a3???????? 681c302300 }
            // n = 5, score = 100
            //   a1????????           |                     
            //   c704242c302300       | mov                 dword ptr [esp], 0x23302c
            //   ff35????????         |                     
            //   a3????????           |                     
            //   681c302300           | push                0x23301c

        $sequence_21 = { 681c302300 6820302300 6818302300 ff15???????? 83c414 a3???????? 85c0 }
            // n = 7, score = 100
            //   681c302300           | push                0x23301c
            //   6820302300           | push                0x233020
            //   6818302300           | push                0x233018
            //   ff15????????         |                     
            //   83c414               | add                 esp, 0x14
            //   a3????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_22 = { 85c0 7412 ffd0 56 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7412                 | je                  0x14
            //   ffd0                 | call                eax
            //   56                   | push                esi

    condition:
        7 of them and filesize < 49152
}