rule win_bitsran_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.bitsran."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bitsran"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d89140c4200 5a 668b31 668930 83c102 83c002 }
            // n = 6, score = 100
            //   8d89140c4200         | lea                 ecx, [ecx + 0x420c14]
            //   5a                   | pop                 edx
            //   668b31               | mov                 si, word ptr [ecx]
            //   668930               | mov                 word ptr [eax], si
            //   83c102               | add                 ecx, 2
            //   83c002               | add                 eax, 2

        $sequence_1 = { c686c800000043 c6864b01000043 c74668e0074200 6a0d e8???????? 59 }
            // n = 6, score = 100
            //   c686c800000043       | mov                 byte ptr [esi + 0xc8], 0x43
            //   c6864b01000043       | mov                 byte ptr [esi + 0x14b], 0x43
            //   c74668e0074200       | mov                 dword ptr [esi + 0x68], 0x4207e0
            //   6a0d                 | push                0xd
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_2 = { 53 8d85f4fdffff 50 8db744020000 }
            // n = 4, score = 100
            //   53                   | push                ebx
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   50                   | push                eax
            //   8db744020000         | lea                 esi, [edi + 0x244]

        $sequence_3 = { 395910 7cac 8b7514 8d95bcf9ffff 52 53 }
            // n = 6, score = 100
            //   395910               | cmp                 dword ptr [ecx + 0x10], ebx
            //   7cac                 | jl                  0xffffffae
            //   8b7514               | mov                 esi, dword ptr [ebp + 0x14]
            //   8d95bcf9ffff         | lea                 edx, [ebp - 0x644]
            //   52                   | push                edx
            //   53                   | push                ebx

        $sequence_4 = { 85c0 0f8584000000 6806020000 50 8d8deafaffff 51 668985e8faffff }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f8584000000         | jne                 0x8a
            //   6806020000           | push                0x206
            //   50                   | push                eax
            //   8d8deafaffff         | lea                 ecx, [ebp - 0x516]
            //   51                   | push                ecx
            //   668985e8faffff       | mov                 word ptr [ebp - 0x518], ax

        $sequence_5 = { 57 8d45ec 50 8d8decfbffff }
            // n = 4, score = 100
            //   57                   | push                edi
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   8d8decfbffff         | lea                 ecx, [ebp - 0x414]

        $sequence_6 = { c745fc99ffffff 83ceff 8b0b 8d45a8 50 51 e8???????? }
            // n = 7, score = 100
            //   c745fc99ffffff       | mov                 dword ptr [ebp - 4], 0xffffff99
            //   83ceff               | or                  esi, 0xffffffff
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   8d45a8               | lea                 eax, [ebp - 0x58]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_7 = { 68???????? 50 898df8feffff 8995fcfeffff e8???????? 8bf0 }
            // n = 6, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   898df8feffff         | mov                 dword ptr [ebp - 0x108], ecx
            //   8995fcfeffff         | mov                 dword ptr [ebp - 0x104], edx
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_8 = { 68???????? 8d8decf3ffff 68???????? 51 }
            // n = 4, score = 100
            //   68????????           |                     
            //   8d8decf3ffff         | lea                 ecx, [ebp - 0xc14]
            //   68????????           |                     
            //   51                   | push                ecx

        $sequence_9 = { 3b7804 0f8daa050000 837e04ff 7409 }
            // n = 4, score = 100
            //   3b7804               | cmp                 edi, dword ptr [eax + 4]
            //   0f8daa050000         | jge                 0x5b0
            //   837e04ff             | cmp                 dword ptr [esi + 4], -1
            //   7409                 | je                  0xb

    condition:
        7 of them and filesize < 344064
}