rule win_broler_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.broler."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.broler"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 50 ff15???????? 3bc3 7408 8d4dc8 51 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   3bc3                 | cmp                 eax, ebx
            //   7408                 | je                  0xa
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]
            //   51                   | push                ecx

        $sequence_1 = { 885dd4 720c 8b55b8 52 e8???????? 83c404 837d1c10 }
            // n = 7, score = 100
            //   885dd4               | mov                 byte ptr [ebp - 0x2c], bl
            //   720c                 | jb                  0xe
            //   8b55b8               | mov                 edx, dword ptr [ebp - 0x48]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   837d1c10             | cmp                 dword ptr [ebp + 0x1c], 0x10

        $sequence_2 = { 84c9 75f9 2bc2 8bf8 8bc3 8d75d4 }
            // n = 6, score = 100
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   2bc2                 | sub                 eax, edx
            //   8bf8                 | mov                 edi, eax
            //   8bc3                 | mov                 eax, ebx
            //   8d75d4               | lea                 esi, [ebp - 0x2c]

        $sequence_3 = { 894508 c1f818 8bdf c1fb18 81e3ff000000 3283085b4100 8b5d0c }
            // n = 7, score = 100
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   c1f818               | sar                 eax, 0x18
            //   8bdf                 | mov                 ebx, edi
            //   c1fb18               | sar                 ebx, 0x18
            //   81e3ff000000         | and                 ebx, 0xff
            //   3283085b4100         | xor                 al, byte ptr [ebx + 0x415b08]
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]

        $sequence_4 = { 8bf8 ff15???????? 85ff 7508 57 53 ff15???????? }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   ff15????????         |                     
            //   85ff                 | test                edi, edi
            //   7508                 | jne                 0xa
            //   57                   | push                edi
            //   53                   | push                ebx
            //   ff15????????         |                     

        $sequence_5 = { 8bcc 895910 c741140f000000 8d5508 89a51cdffcff }
            // n = 5, score = 100
            //   8bcc                 | mov                 ecx, esp
            //   895910               | mov                 dword ptr [ecx + 0x10], ebx
            //   c741140f000000       | mov                 dword ptr [ecx + 0x14], 0xf
            //   8d5508               | lea                 edx, [ebp + 8]
            //   89a51cdffcff         | mov                 dword ptr [ebp - 0x320e4], esp

        $sequence_6 = { 50 83c8ff 33db e8???????? 8d8d8cfeffff e8???????? 83c440 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   83c8ff               | or                  eax, 0xffffffff
            //   33db                 | xor                 ebx, ebx
            //   e8????????           |                     
            //   8d8d8cfeffff         | lea                 ecx, [ebp - 0x174]
            //   e8????????           |                     
            //   83c440               | add                 esp, 0x40

        $sequence_7 = { 85c0 0f8489000000 33d2 f7b6cc030000 85d2 0f8579000000 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   0f8489000000         | je                  0x8f
            //   33d2                 | xor                 edx, edx
            //   f7b6cc030000         | div                 dword ptr [esi + 0x3cc]
            //   85d2                 | test                edx, edx
            //   0f8579000000         | jne                 0x7f

        $sequence_8 = { c60100 e8???????? 8dbd8cfeffff e8???????? 83c41c 8bf8 8db554feffff }
            // n = 7, score = 100
            //   c60100               | mov                 byte ptr [ecx], 0
            //   e8????????           |                     
            //   8dbd8cfeffff         | lea                 edi, [ebp - 0x174]
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   8bf8                 | mov                 edi, eax
            //   8db554feffff         | lea                 esi, [ebp - 0x1ac]

        $sequence_9 = { 03d8 3bd9 7624 83fa10 7204 8b06 }
            // n = 6, score = 100
            //   03d8                 | add                 ebx, eax
            //   3bd9                 | cmp                 ebx, ecx
            //   7624                 | jbe                 0x26
            //   83fa10               | cmp                 edx, 0x10
            //   7204                 | jb                  6
            //   8b06                 | mov                 eax, dword ptr [esi]

    condition:
        7 of them and filesize < 275456
}