rule win_brute_ratel_c4_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.brute_ratel_c4."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.brute_ratel_c4"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? b801000000 4883c448 c3 48894c2408 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   b801000000           | inc                 ecx
            //   4883c448             | mov                 eax, 0x40600
            //   c3                   | dec                 eax
            //   48894c2408           | lea                 edx, [0x2fd0]

        $sequence_1 = { 4154 55 57 56 53 4883ec20 4c8d257f1e0400 }
            // n = 7, score = 100
            //   4154                 | mov                 eax, dword ptr [edi + 0x10]
            //   55                   | inc                 ecx
            //   57                   | push                esp
            //   56                   | push                ebp
            //   53                   | push                edi
            //   4883ec20             | push                esi
            //   4c8d257f1e0400       | push                ebx

        $sequence_2 = { 89442438 4863442430 486bc010 488d0de32e0400 4803c8 488bc1 48634c2434 }
            // n = 7, score = 100
            //   89442438             | add                 ebp, 4
            //   4863442430           | dec                 esi
            //   486bc010             | nop                 word ptr [eax + eax]
            //   488d0de32e0400       | movups              xmmword ptr [edi], xmm0
            //   4803c8               | dec                 eax
            //   488bc1               | test                esi, esi
            //   48634c2434           | je                  0x29

        $sequence_3 = { 48c744242800000000 41b800060400 488d15d02f0000 488d4c2420 e8???????? }
            // n = 5, score = 100
            //   48c744242800000000     | inc    ecx
            //   41b800060400         | mov                 eax, dword ptr [edi + esi*4 + 0x10]
            //   488d15d02f0000       | inc                 ecx
            //   488d4c2420           | mov                 esi, dword ptr [edi + eax]
            //   e8????????           |                     

        $sequence_4 = { ffcd 85c0 75c7 4801de 8b4710 }
            // n = 5, score = 100
            //   ffcd                 | dec                 ebp
            //   85c0                 | test                eax, eax
            //   75c7                 | jne                 0xffffffc9
            //   4801de               | dec                 eax
            //   8b4710               | add                 esi, ebx

        $sequence_5 = { 741a 85f6 740e 4889c1 baffffffff ff15???????? }
            // n = 6, score = 100
            //   741a                 | mov                 ecx, dword ptr [edi + esi*4 + 8]
            //   85f6                 | inc                 ebp
            //   740e                 | mov                 eax, dword ptr [edi + esi*4 + 0xc]
            //   4889c1               | dec                 esp
            //   baffffffff           | add                 ecx, edi
            //   ff15????????         |                     

        $sequence_6 = { 4533c0 ba01000000 48b90000008001000000 ff9424a0000000 89842480000000 83bc248000000000 750f }
            // n = 7, score = 100
            //   4533c0               | lea                 edx, [0x2fd0]
            //   ba01000000           | dec                 eax
            //   48b90000008001000000     | lea    ecx, [esp + 0x20]
            //   ff9424a0000000       | cmp                 dword ptr [eax + 0x20], 0
            //   89842480000000       | je                  0x67
            //   83bc248000000000     | dec                 eax
            //   750f                 | mov                 eax, dword ptr [esp + 0x30]

        $sequence_7 = { e8???????? 4889442428 4c8d0532200000 488b542428 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   4889442428           | dec                 ecx
            //   4c8d0532200000       | lea                 ebp, [edi + eax]
            //   488b542428           | dec                 eax

        $sequence_8 = { 0f1107 e8???????? 4885f6 7424 }
            // n = 4, score = 100
            //   0f1107               | mov                 edx, 0xffffffff
            //   e8????????           |                     
            //   4885f6               | dec                 eax
            //   7424                 | mov                 esi, ecx

        $sequence_9 = { 418b4cb708 458b44b70c 4c01f9 49d1e8 488b542430 }
            // n = 5, score = 100
            //   418b4cb708           | dec                 eax
            //   458b44b70c           | sub                 esp, 0x20
            //   4c01f9               | dec                 esp
            //   49d1e8               | lea                 esp, [0x41e7f]
            //   488b542430           | inc                 ecx

        $sequence_10 = { 83782800 0f8491000000 488b442430 83782000 7465 488b442430 }
            // n = 6, score = 100
            //   83782800             | mov                 eax, 0x40600
            //   0f8491000000         | dec                 eax
            //   488b442430           | lea                 edx, [0x2fd0]
            //   83782000             | dec                 eax
            //   7465                 | lea                 ecx, [esp + 0x20]
            //   488b442430           | dec                 eax

        $sequence_11 = { 418b44b710 418b3407 498d2c07 4883c504 ffce 660f1f440000 }
            // n = 6, score = 100
            //   418b44b710           | mov                 edx, dword ptr [esp + 0x30]
            //   418b3407             | je                  0x1c
            //   498d2c07             | test                esi, esi
            //   4883c504             | je                  0x10
            //   ffce                 | dec                 eax
            //   660f1f440000         | mov                 ecx, eax

        $sequence_12 = { 488b2d???????? 4889ce 895500 89d3 }
            // n = 4, score = 100
            //   488b2d????????       |                     
            //   4889ce               | dec                 ecx
            //   895500               | shr                 eax, 1
            //   89d3                 | dec                 eax

        $sequence_13 = { 4c8d0532200000 488b542428 488d4c2420 e8???????? }
            // n = 4, score = 100
            //   4c8d0532200000       | dec                 eax
            //   488b542428           | lea                 ecx, [esp + 0x20]
            //   488d4c2420           | dec                 eax
            //   e8????????           |                     

        $sequence_14 = { 0f84d7000000 83f910 0f8550020000 0fb737 81e2c0000000 6685f6 }
            // n = 6, score = 100
            //   0f84d7000000         | je                  0xdd
            //   83f910               | cmp                 ecx, 0x10
            //   0f8550020000         | jne                 0x256
            //   0fb737               | movzx               esi, word ptr [edi]
            //   81e2c0000000         | and                 edx, 0xc0
            //   6685f6               | test                si, si

        $sequence_15 = { 83782000 7465 488b442430 488b00 8b4028 488b4c2440 }
            // n = 6, score = 100
            //   83782000             | dec                 eax
            //   7465                 | arpl                word ptr [esp + 0x30], ax
            //   488b442430           | dec                 eax
            //   488b00               | imul                eax, eax, 0x10
            //   8b4028               | dec                 eax
            //   488b4c2440           | lea                 ecx, [0x42ee3]

    condition:
        7 of them and filesize < 607232
}