rule win_cactus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cactus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cactus"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 48897cc500 488b05???????? c705????????01000000 4883c010 488905???????? f08305????????01 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   48897cc500           | jmp                 0x983
            //   488b05????????       |                     
            //   c705????????01000000     |     
            //   4883c010             | dec                 eax
            //   488905????????       |                     
            //   f08305????????01     |                     

        $sequence_1 = { e8???????? 488d05524c3300 4c8b442430 4889e9 4a8d543850 e8???????? 448b9c240c030000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d05524c3300       | jne                 0x977
            //   4c8b442430           | cmp                 byte ptr [edx], 0
            //   4889e9               | je                  0x991
            //   4a8d543850           | movsx               eax, byte ptr [esp + 0x70]
            //   e8????????           |                     
            //   448b9c240c030000     | inc                 eax

        $sequence_2 = { f30f6f842480000000 660fc6c901 660f73d138 48894c2478 660fc6c001 660fdbc6 660fd4c1 }
            // n = 7, score = 100
            //   f30f6f842480000000     | pop    esi
            //   660fc6c901           | pop                 edi
            //   660f73d138           | test                eax, eax
            //   48894c2478           | setne               al
            //   660fc6c001           | movzx               eax, al
            //   660fdbc6             | dec                 eax
            //   660fd4c1             | add                 esp, 0x88

        $sequence_3 = { e8???????? 4c8d05648e1900 ba80010000 488d0d388d1900 e8???????? 4531c0 ba94000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8d05648e1900       | je                  0x26b
            //   ba80010000           | nop                 dword ptr [eax]
            //   488d0d388d1900       | je                  0x2da
            //   e8????????           |                     
            //   4531c0               | dec                 eax
            //   ba94000000           | mov                 eax, dword ptr [esp + 0x20]

        $sequence_4 = { e8???????? 4c8d05e1cc2400 bad3010000 488d0d6dca2400 e8???????? 4531c0 ba65000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8d05e1cc2400       | xor                 ebx, ebx
            //   bad3010000           | mov                 eax, ebx
            //   488d0d6dca2400       | dec                 eax
            //   e8????????           |                     
            //   4531c0               | add                 esp, 0x20
            //   ba65000000           | pop                 ebx

        $sequence_5 = { e8???????? 488d159c933a00 4889f9 4989c0 e8???????? 85c0 7425 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d159c933a00       | mov                 edx, dword ptr [eax]
            //   4889f9               | je                  0x16d5
            //   4989c0               | test                eax, eax
            //   e8????????           |                     
            //   85c0                 | je                  0x16c9
            //   7425                 | dec                 eax

        $sequence_6 = { e8???????? 4889c7 4885c0 0f8447010000 488d5008 4889f1 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889c7               | test                esi, esi
            //   4885c0               | je                  0xe74
            //   0f8447010000         | dec                 eax
            //   488d5008             | mov                 ecx, esi
            //   4889f1               | test                eax, eax
            //   e8????????           |                     

        $sequence_7 = { 89c2 31c6 4189c3 c1c202 41c1c30a 31f2 4431da }
            // n = 7, score = 100
            //   89c2                 | dec                 eax
            //   31c6                 | mov                 ecx, ebx
            //   4189c3               | inc                 ebp
            //   c1c202               | xor                 eax, eax
            //   41c1c30a             | mov                 edx, 0x7a
            //   31f2                 | mov                 ecx, 0x20
            //   4431da               | dec                 esp

        $sequence_8 = { e8???????? 488b15???????? 4889f1 e8???????? 85c0 755f 803b00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b15????????       |                     
            //   4889f1               | je                  0xf67
            //   e8????????           |                     
            //   85c0                 | je                  0xf7f
            //   755f                 | inc                 ebp
            //   803b00               | xor                 ecx, ecx

        $sequence_9 = { e8???????? 4889c3 4885c0 0f84ba000000 b801000000 874310 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889c3               | dec                 ecx
            //   4885c0               | lea                 eax, [esp - 1]
            //   0f84ba000000         | dec                 eax
            //   b801000000           | cmp                 eax, 6
            //   874310               | je                  0xe54
            //   e8????????           |                     

    condition:
        7 of them and filesize < 13587456
}