rule win_cameleon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.cameleon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cameleon"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b36 33c0 6689045e 3bc7 5b 1bc0 5f }
            // n = 7, score = 100
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   33c0                 | xor                 eax, eax
            //   6689045e             | mov                 word ptr [esi + ebx*2], ax
            //   3bc7                 | cmp                 eax, edi
            //   5b                   | pop                 ebx
            //   1bc0                 | sbb                 eax, eax
            //   5f                   | pop                 edi

        $sequence_1 = { c645fc19 8d55b0 837dc408 0f4355b0 663902 }
            // n = 5, score = 100
            //   c645fc19             | mov                 byte ptr [ebp - 4], 0x19
            //   8d55b0               | lea                 edx, [ebp - 0x50]
            //   837dc408             | cmp                 dword ptr [ebp - 0x3c], 8
            //   0f4355b0             | cmovae              edx, dword ptr [ebp - 0x50]
            //   663902               | cmp                 word ptr [edx], ax

        $sequence_2 = { 84c0 741a 85db 7507 c746349cfb0410 57 ff7634 }
            // n = 7, score = 100
            //   84c0                 | test                al, al
            //   741a                 | je                  0x1c
            //   85db                 | test                ebx, ebx
            //   7507                 | jne                 9
            //   c746349cfb0410       | mov                 dword ptr [esi + 0x34], 0x1004fb9c
            //   57                   | push                edi
            //   ff7634               | push                dword ptr [esi + 0x34]

        $sequence_3 = { 2bd9 03df 8938 8b4620 }
            // n = 4, score = 100
            //   2bd9                 | sub                 ebx, ecx
            //   03df                 | add                 ebx, edi
            //   8938                 | mov                 dword ptr [eax], edi
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]

        $sequence_4 = { 57 8bf1 c745fc00000000 8b7e34 }
            // n = 4, score = 100
            //   57                   | push                edi
            //   8bf1                 | mov                 esi, ecx
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b7e34               | mov                 edi, dword ptr [esi + 0x34]

        $sequence_5 = { c707???????? e8???????? 0f1000 8d45b4 50 0f114708 e8???????? }
            // n = 7, score = 100
            //   c707????????         |                     
            //   e8????????           |                     
            //   0f1000               | movups              xmm0, xmmword ptr [eax]
            //   8d45b4               | lea                 eax, [ebp - 0x4c]
            //   50                   | push                eax
            //   0f114708             | movups              xmmword ptr [edi + 8], xmm0
            //   e8????????           |                     

        $sequence_6 = { 0f85c08fffff 8d0d203c0510 ba1b000000 e8???????? 5a c3 833d????????00 }
            // n = 7, score = 100
            //   0f85c08fffff         | jne                 0xffff8fc6
            //   8d0d203c0510         | lea                 ecx, [0x10053c20]
            //   ba1b000000           | mov                 edx, 0x1b
            //   e8????????           |                     
            //   5a                   | pop                 edx
            //   c3                   | ret                 
            //   833d????????00       |                     

        $sequence_7 = { 66894e02 eb41 83e00f 66c1ff04 0fb71445f0ef0410 0fbfc7 }
            // n = 6, score = 100
            //   66894e02             | mov                 word ptr [esi + 2], cx
            //   eb41                 | jmp                 0x43
            //   83e00f               | and                 eax, 0xf
            //   66c1ff04             | sar                 di, 4
            //   0fb71445f0ef0410     | movzx               edx, word ptr [eax*2 + 0x1004eff0]
            //   0fbfc7               | movsx               eax, di

        $sequence_8 = { e8???????? e9???????? 68???????? 8bcb e8???????? 85c0 0f85f7010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e9????????           |                     
            //   68????????           |                     
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f85f7010000         | jne                 0x1fd

        $sequence_9 = { c645fc19 ba02000000 e9???????? 68???????? }
            // n = 4, score = 100
            //   c645fc19             | mov                 byte ptr [ebp - 4], 0x19
            //   ba02000000           | mov                 edx, 2
            //   e9????????           |                     
            //   68????????           |                     

    condition:
        7 of them and filesize < 824320
}