rule win_chches_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.chches."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chches"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83fbff 0f84a6000000 8b4d14 8bc7 23c1 83f8ff 7506 }
            // n = 7, score = 200
            //   83fbff               | cmp                 ebx, -1
            //   0f84a6000000         | je                  0xac
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]
            //   8bc7                 | mov                 eax, edi
            //   23c1                 | and                 eax, ecx
            //   83f8ff               | cmp                 eax, -1
            //   7506                 | jne                 8

        $sequence_1 = { 89441104 8b550c 8b4a04 8b5668 53 51 50 }
            // n = 7, score = 200
            //   89441104             | mov                 dword ptr [ecx + edx + 4], eax
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b4a04               | mov                 ecx, dword ptr [edx + 4]
            //   8b5668               | mov                 edx, dword ptr [esi + 0x68]
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_2 = { 747a 8b16 8b4244 8b4010 85c0 7454 3903 }
            // n = 7, score = 200
            //   747a                 | je                  0x7c
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8b4244               | mov                 eax, dword ptr [edx + 0x44]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   85c0                 | test                eax, eax
            //   7454                 | je                  0x56
            //   3903                 | cmp                 dword ptr [ebx], eax

        $sequence_3 = { 8b543bfc 8b4218 51 8b4e68 50 ffd1 }
            // n = 6, score = 200
            //   8b543bfc             | mov                 edx, dword ptr [ebx + edi - 4]
            //   8b4218               | mov                 eax, dword ptr [edx + 0x18]
            //   51                   | push                ecx
            //   8b4e68               | mov                 ecx, dword ptr [esi + 0x68]
            //   50                   | push                eax
            //   ffd1                 | call                ecx

        $sequence_4 = { 8b07 895810 8b0f 83c114 3bcb 0f8481000000 8b5508 }
            // n = 7, score = 200
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   895810               | mov                 dword ptr [eax + 0x10], ebx
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   83c114               | add                 ecx, 0x14
            //   3bcb                 | cmp                 ecx, ebx
            //   0f8481000000         | je                  0x87
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_5 = { 81c71d051101 53 897de0 c745fc00000000 e8???????? 83c404 8945c4 }
            // n = 7, score = 200
            //   81c71d051101         | add                 edi, 0x111051d
            //   53                   | push                ebx
            //   897de0               | mov                 dword ptr [ebp - 0x20], edi
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax

        $sequence_6 = { 3b08 7516 ff8fcc000000 8b5644 50 6a00 ffd2 }
            // n = 7, score = 200
            //   3b08                 | cmp                 ecx, dword ptr [eax]
            //   7516                 | jne                 0x18
            //   ff8fcc000000         | dec                 dword ptr [edi + 0xcc]
            //   8b5644               | mov                 edx, dword ptr [esi + 0x44]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ffd2                 | call                edx

        $sequence_7 = { c6857bffffff3a c6857cffffff2a c6857dffffff50 c6857effffffca c6857fffffffe9 c64580ab c64581ec }
            // n = 7, score = 200
            //   c6857bffffff3a       | mov                 byte ptr [ebp - 0x85], 0x3a
            //   c6857cffffff2a       | mov                 byte ptr [ebp - 0x84], 0x2a
            //   c6857dffffff50       | mov                 byte ptr [ebp - 0x83], 0x50
            //   c6857effffffca       | mov                 byte ptr [ebp - 0x82], 0xca
            //   c6857fffffffe9       | mov                 byte ptr [ebp - 0x81], 0xe9
            //   c64580ab             | mov                 byte ptr [ebp - 0x80], 0xab
            //   c64581ec             | mov                 byte ptr [ebp - 0x7f], 0xec

        $sequence_8 = { ffd0 8b0b c1e104 8907 03c1 0f849d000000 8b550c }
            // n = 7, score = 200
            //   ffd0                 | call                eax
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   c1e104               | shl                 ecx, 4
            //   8907                 | mov                 dword ptr [edi], eax
            //   03c1                 | add                 eax, ecx
            //   0f849d000000         | je                  0xa3
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]

        $sequence_9 = { 8b45bc 8b7de8 83c408 c745fc01000000 8b9680000000 50 ffd2 }
            // n = 7, score = 200
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]
            //   8b7de8               | mov                 edi, dword ptr [ebp - 0x18]
            //   83c408               | add                 esp, 8
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   8b9680000000         | mov                 edx, dword ptr [esi + 0x80]
            //   50                   | push                eax
            //   ffd2                 | call                edx

    condition:
        7 of them and filesize < 122880
}