rule win_chinotto_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.chinotto."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chinotto"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8987f0e74100 83c704 83ff28 72e6 5f 5e c3 }
            // n = 7, score = 100
            //   8987f0e74100         | mov                 dword ptr [edi + 0x41e7f0], eax
            //   83c704               | add                 edi, 4
            //   83ff28               | cmp                 edi, 0x28
            //   72e6                 | jb                  0xffffffe8
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c3                   | ret                 

        $sequence_1 = { 75ed 8b4e4c 894e50 c7473cc04a4000 eb06 }
            // n = 5, score = 100
            //   75ed                 | jne                 0xffffffef
            //   8b4e4c               | mov                 ecx, dword ptr [esi + 0x4c]
            //   894e50               | mov                 dword ptr [esi + 0x50], ecx
            //   c7473cc04a4000       | mov                 dword ptr [edi + 0x3c], 0x404ac0
            //   eb06                 | jmp                 8

        $sequence_2 = { 894e0c 66c7065265 66c746026720 66c746045265 66c746066164 66c746082053 66c7460a7563 }
            // n = 7, score = 100
            //   894e0c               | mov                 dword ptr [esi + 0xc], ecx
            //   66c7065265           | mov                 word ptr [esi], 0x6552
            //   66c746026720         | mov                 word ptr [esi + 2], 0x2067
            //   66c746045265         | mov                 word ptr [esi + 4], 0x6552
            //   66c746066164         | mov                 word ptr [esi + 6], 0x6461
            //   66c746082053         | mov                 word ptr [esi + 8], 0x5320
            //   66c7460a7563         | mov                 word ptr [esi + 0xa], 0x6375

        $sequence_3 = { 8b5ddc 3bdf 7426 f7460800000200 7424 83fa05 771f }
            // n = 7, score = 100
            //   8b5ddc               | mov                 ebx, dword ptr [ebp - 0x24]
            //   3bdf                 | cmp                 ebx, edi
            //   7426                 | je                  0x28
            //   f7460800000200       | test                dword ptr [esi + 8], 0x20000
            //   7424                 | je                  0x26
            //   83fa05               | cmp                 edx, 5
            //   771f                 | ja                  0x21

        $sequence_4 = { 721d 8b4830 3b4834 7308 }
            // n = 4, score = 100
            //   721d                 | jb                  0x1f
            //   8b4830               | mov                 ecx, dword ptr [eax + 0x30]
            //   3b4834               | cmp                 ecx, dword ptr [eax + 0x34]
            //   7308                 | jae                 0xa

        $sequence_5 = { 66894da6 b973000000 66894da8 b925000000 66894daa b973000000 }
            // n = 6, score = 100
            //   66894da6             | mov                 word ptr [ebp - 0x5a], cx
            //   b973000000           | mov                 ecx, 0x73
            //   66894da8             | mov                 word ptr [ebp - 0x58], cx
            //   b925000000           | mov                 ecx, 0x25
            //   66894daa             | mov                 word ptr [ebp - 0x56], cx
            //   b973000000           | mov                 ecx, 0x73

        $sequence_6 = { 897de8 3b7de4 0f8782010000 25ff7f0000 0fb61c02 8dbc318f000000 0fb63c07 }
            // n = 7, score = 100
            //   897de8               | mov                 dword ptr [ebp - 0x18], edi
            //   3b7de4               | cmp                 edi, dword ptr [ebp - 0x1c]
            //   0f8782010000         | ja                  0x188
            //   25ff7f0000           | and                 eax, 0x7fff
            //   0fb61c02             | movzx               ebx, byte ptr [edx + eax]
            //   8dbc318f000000       | lea                 edi, [ecx + esi + 0x8f]
            //   0fb63c07             | movzx               edi, byte ptr [edi + eax]

        $sequence_7 = { 8bec b810100000 e8???????? a1???????? 33c5 8945f8 8b4508 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   b810100000           | mov                 eax, 0x1010
            //   e8????????           |                     
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_8 = { 8b853cf7ffff 83c420 03d8 89b538f7ffff 85c0 758a 8b8534f7ffff }
            // n = 7, score = 100
            //   8b853cf7ffff         | mov                 eax, dword ptr [ebp - 0x8c4]
            //   83c420               | add                 esp, 0x20
            //   03d8                 | add                 ebx, eax
            //   89b538f7ffff         | mov                 dword ptr [ebp - 0x8c8], esi
            //   85c0                 | test                eax, eax
            //   758a                 | jne                 0xffffff8c
            //   8b8534f7ffff         | mov                 eax, dword ptr [ebp - 0x8cc]

        $sequence_9 = { 56 52 50 8b4508 8b4834 8b5030 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   52                   | push                edx
            //   50                   | push                eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4834               | mov                 ecx, dword ptr [eax + 0x34]
            //   8b5030               | mov                 edx, dword ptr [eax + 0x30]

    condition:
        7 of them and filesize < 300032
}