rule win_colony_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.colony."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.colony"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 5e c3 f30f7e05???????? 660fd606 }
            // n = 5, score = 600
            //   33c0                 | btr                 dword ptr [ecx + 0x18], 0xf
            //   5e                   | lock inc            dword ptr [eax]
            //   c3                   | dec                 eax
            //   f30f7e05????????     |                     
            //   660fd606             | lea                 eax, [ecx + 0x28]

        $sequence_1 = { 740f 0301 eb0b a801 }
            // n = 4, score = 600
            //   740f                 | test                al, al
            //   0301                 | jne                 0x11
            //   eb0b                 | movss               xmm1, dword ptr [ecx]
            //   a801                 | cvtps2pd            xmm1, xmm1

        $sequence_2 = { 5b c3 b901000000 66894808 }
            // n = 4, score = 600
            //   5b                   | push                esi
            //   c3                   | or                  eax, ecx
            //   b901000000           | mov                 dword ptr [edi + 4], eax
            //   66894808             | mov                 ecx, dword ptr [ebx + 8]

        $sequence_3 = { 7407 b901000000 eb0a 33c9 803f01 0f95c1 33c0 }
            // n = 7, score = 600
            //   7407                 | movd                xmm0, dword ptr [ecx + 4]
            //   b901000000           | cvtdq2pd            xmm0, xmm0
            //   eb0a                 | test                al, al
            //   33c9                 | jne                 0xd
            //   803f01               | movss               xmm1, dword ptr [ecx]
            //   0f95c1               | movd                xmm0, dword ptr [ecx + 4]
            //   33c0                 | cvtdq2pd            xmm0, xmm0

        $sequence_4 = { 8b00 83f801 7e5c f7420400080000 }
            // n = 4, score = 600
            //   8b00                 | jmp                 0x13
            //   83f801               | xor                 ecx, ecx
            //   7e5c                 | cmp                 byte ptr [edi], 1
            //   f7420400080000       | setne               cl

        $sequence_5 = { 33c0 5b 8be5 5d c3 8b5df8 8b4b18 }
            // n = 7, score = 600
            //   33c0                 | test                ecx, ecx
            //   5b                   | jle                 0xe
            //   8be5                 | or                  eax, ecx
            //   5d                   | mov                 dword ptr [edi], eax
            //   c3                   | mov                 ecx, dword ptr [ebx + 4]
            //   8b5df8               | mov                 eax, ecx
            //   8b4b18               | or                  eax, ecx

        $sequence_6 = { 33c0 5e 5d c3 8b4d0c 85c9 7e0c }
            // n = 7, score = 600
            //   33c0                 | inc                 ecx
            //   5e                   | mov                 eax, 6
            //   5d                   | dec                 eax
            //   c3                   | lea                 edx, [0xfd88]
            //   8b4d0c               | dec                 eax
            //   85c9                 | cmp                 dword ptr [eax - 0x10], edx
            //   7e0c                 | je                  0x22

        $sequence_7 = { 0f95c0 33cd 5e 48 }
            // n = 4, score = 600
            //   0f95c0               | mov                 dword ptr [edi], eax
            //   33cd                 | mov                 ecx, dword ptr [ebx + 4]
            //   5e                   | mov                 eax, ecx
            //   48                   | ror                 eax, 8

        $sequence_8 = { 0bc1 894204 8b4510 c1e810 }
            // n = 4, score = 600
            //   0bc1                 | xor                 eax, eax
            //   894204               | pop                 esi
            //   8b4510               | ret                 
            //   c1e810               | movq                qword ptr [esi], xmm0

        $sequence_9 = { 660f6e4104 f30fe6c0 84c0 7509 f30f1009 0f5ac9 }
            // n = 6, score = 600
            //   660f6e4104           | pop                 esi
            //   f30fe6c0             | dec                 eax
            //   84c0                 | setne               al
            //   7509                 | xor                 ecx, ebp
            //   f30f1009             | pop                 esi
            //   0f5ac9               | dec                 eax

        $sequence_10 = { 8a4203 8841fe 8a4202 8841ff 8b02 c1e808 8801 }
            // n = 7, score = 600
            //   8a4203               | je                  9
            //   8841fe               | mov                 ecx, 1
            //   8a4202               | jmp                 0x11
            //   8841ff               | xor                 ecx, ecx
            //   8b02                 | cmp                 byte ptr [edi], 1
            //   c1e808               | imul                eax, edx, 0x30674eef
            //   8801                 | imul                edx, edx, 0x48f0000

        $sequence_11 = { 0bc1 8907 8b4b04 8bc1 }
            // n = 4, score = 600
            //   0bc1                 | dec                 eax
            //   8907                 | mov                 edx, dword ptr [eax]
            //   8b4b04               | mov                 dword ptr [eax], 9
            //   8bc1                 | dec                 eax

        $sequence_12 = { 0bc1 8902 8b4508 c1e810 25ff000000 }
            // n = 5, score = 600
            //   0bc1                 | dec                 eax
            //   8902                 | lea                 eax, [0xf2a5]
            //   8b4508               | dec                 eax
            //   c1e810               | cmp                 ecx, eax
            //   25ff000000           | ja                  0x30

        $sequence_13 = { 8b420c 2b4208 660f6ec0 f30fe6c0 }
            // n = 4, score = 600
            //   8b420c               | add                 eax, dword ptr [ecx]
            //   2b4208               | jmp                 0x11
            //   660f6ec0             | mov                 eax, dword ptr [eax]
            //   f30fe6c0             | cmp                 eax, 1

        $sequence_14 = { 69d200008f04 2bc8 c1e910 69c161a4f778 2bd0 }
            // n = 5, score = 600
            //   69d200008f04         | mov                 eax, ecx
            //   2bc8                 | push                esi
            //   c1e910               | lea                 esi, [edi + 4]
            //   69c161a4f778         | je                  0x12a
            //   2bd0                 | cmp                 eax, 0xfb0

        $sequence_15 = { 0bc1 894704 8b4b08 8bc1 }
            // n = 4, score = 600
            //   0bc1                 | mov                 eax, ecx
            //   894704               | ror                 eax, 8
            //   8b4b08               | rol                 ecx, 8
            //   8bc1                 | or                  eax, ecx

        $sequence_16 = { 488364243000 8364242800 41b803000000 488d0d308e0000 4533c9 }
            // n = 5, score = 100
            //   488364243000         | dec                 eax
            //   8364242800           | and                 dword ptr [esp + 0x30], 0
            //   41b803000000         | and                 dword ptr [esp + 0x28], 0
            //   488d0d308e0000       | inc                 ecx
            //   4533c9               | mov                 eax, 3

        $sequence_17 = { 4152 4153 4154 4155 4156 4157 9c }
            // n = 7, score = 100
            //   4152                 | inc                 ecx
            //   4153                 | mov                 eax, esp
            //   4154                 | mov                 edx, 0xd
            //   4155                 | dec                 esp
            //   4156                 | lea                 ecx, [0xd2a0]
            //   4157                 | inc                 ecx
            //   9c                   | sub                 eax, esi

        $sequence_18 = { f0ff00 488d4128 41b806000000 488d1588fd0000 483950f0 740b 488b10 }
            // n = 7, score = 100
            //   f0ff00               | inc                 ecx
            //   488d4128             | push                edx
            //   41b806000000         | inc                 ecx
            //   488d1588fd0000       | push                ebx
            //   483950f0             | inc                 ecx
            //   740b                 | push                esp
            //   488b10               | inc                 ecx

        $sequence_19 = { 488d15c1980000 483305???????? 488bcb 488905???????? ff15???????? 488d15c3980000 483305???????? }
            // n = 7, score = 100
            //   488d15c1980000       | dec                 eax
            //   483305????????       |                     
            //   488bcb               | cmp                 eax, edi
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488d15c3980000       | jl                  0xfffffee6
            //   483305????????       |                     

        $sequence_20 = { 488d05a5f20000 483bc8 772b 0fba71180f }
            // n = 4, score = 100
            //   488d05a5f20000       | dec                 eax
            //   483bc8               | mov                 ecx, ebx
            //   772b                 | dec                 eax
            //   0fba71180f           | lea                 edx, [0x98c3]

        $sequence_21 = { 488905???????? ff15???????? 483305???????? 488d1546980000 }
            // n = 4, score = 100
            //   488905????????       |                     
            //   ff15????????         |                     
            //   483305????????       |                     
            //   488d1546980000       | dec                 eax

        $sequence_22 = { 4863442450 483bc7 0f8cddfeffff 418bc4 ba0d000000 4c8d0da0d20000 412bc6 }
            // n = 7, score = 100
            //   4863442450           | lea                 ecx, [0x8e30]
            //   483bc7               | inc                 ebp
            //   0f8cddfeffff         | xor                 ecx, ecx
            //   418bc4               | dec                 eax
            //   ba0d000000           | lea                 edx, [0x9846]
            //   4c8d0da0d20000       | dec                 eax
            //   412bc6               | arpl                word ptr [esp + 0x50], ax

        $sequence_23 = { c70009000000 e8???????? 4883c8ff 4883c428 c3 4863d1 4c8d0546cc0000 }
            // n = 7, score = 100
            //   c70009000000         | push                ebp
            //   e8????????           |                     
            //   4883c8ff             | inc                 ecx
            //   4883c428             | push                esi
            //   c3                   | inc                 ecx
            //   4863d1               | push                edi
            //   4c8d0546cc0000       | pushfd              

    condition:
        7 of them and filesize < 7599104
}