rule win_darkcomet_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.darkcomet"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 648920 8b45ec c6404801 33d2 55 68???????? 64ff32 }
            // n = 7, score = 200
            //   648920               | mov                 dword ptr fs:[eax], esp
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   c6404801             | mov                 byte ptr [eax + 0x48], 1
            //   33d2                 | xor                 edx, edx
            //   55                   | push                ebp
            //   68????????           |                     
            //   64ff32               | push                dword ptr fs:[edx]

        $sequence_1 = { 837f4800 0f858c030000 6a00 6a01 6a02 e8???????? 8945fc }
            // n = 7, score = 200
            //   837f4800             | cmp                 dword ptr [edi + 0x48], 0
            //   0f858c030000         | jne                 0x392
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6a02                 | push                2
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_2 = { 8d45ec ba???????? e8???????? 837de800 750d 8d45e8 ba???????? }
            // n = 7, score = 200
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   ba????????           |                     
            //   e8????????           |                     
            //   837de800             | cmp                 dword ptr [ebp - 0x18], 0
            //   750d                 | jne                 0xf
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   ba????????           |                     

        $sequence_3 = { 888543feffff 8b55f4 b8???????? e8???????? 8bc8 8d45f4 ba01000000 }
            // n = 7, score = 200
            //   888543feffff         | mov                 byte ptr [ebp - 0x1bd], al
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   b8????????           |                     
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   ba01000000           | mov                 edx, 1

        $sequence_4 = { ff30 8d8dc4feffff 8bd6 8b45e8 8b38 ff570c }
            // n = 6, score = 200
            //   ff30                 | push                dword ptr [eax]
            //   8d8dc4feffff         | lea                 ecx, [ebp - 0x13c]
            //   8bd6                 | mov                 edx, esi
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b38                 | mov                 edi, dword ptr [eax]
            //   ff570c               | call                dword ptr [edi + 0xc]

        $sequence_5 = { 33c0 55 68???????? 64ff30 648920 8b4644 85c0 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   55                   | push                ebp
            //   68????????           |                     
            //   64ff30               | push                dword ptr fs:[eax]
            //   648920               | mov                 dword ptr fs:[eax], esp
            //   8b4644               | mov                 eax, dword ptr [esi + 0x44]
            //   85c0                 | test                eax, eax

        $sequence_6 = { 8b45f8 ba???????? e8???????? 7509 b001 e8???????? eb07 }
            // n = 7, score = 200
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   ba????????           |                     
            //   e8????????           |                     
            //   7509                 | jne                 0xb
            //   b001                 | mov                 al, 1
            //   e8????????           |                     
            //   eb07                 | jmp                 9

        $sequence_7 = { 6a00 56 8d4340 50 8d45f0 50 e8???????? }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   56                   | push                esi
            //   8d4340               | lea                 eax, [ebx + 0x40]
            //   50                   | push                eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { 8d45f8 b90d000000 ba01000000 e8???????? 8d45f4 8b55f8 e8???????? }
            // n = 7, score = 200
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   b90d000000           | mov                 ecx, 0xd
            //   ba01000000           | mov                 edx, 1
            //   e8????????           |                     
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   e8????????           |                     

        $sequence_9 = { ba???????? e8???????? 8b9594f9ffff 33c0 e8???????? 68???????? 8d8590f9ffff }
            // n = 7, score = 200
            //   ba????????           |                     
            //   e8????????           |                     
            //   8b9594f9ffff         | mov                 edx, dword ptr [ebp - 0x66c]
            //   33c0                 | xor                 eax, eax
            //   e8????????           |                     
            //   68????????           |                     
            //   8d8590f9ffff         | lea                 eax, [ebp - 0x670]

    condition:
        7 of them and filesize < 1499136
}