rule win_daserf_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.daserf."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.daserf"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81c328a25d5a 0545c9ac22 05c26febe9 81c3417cc57d 2dcb488290 81c31b4b740f }
            // n = 6, score = 100
            //   81c328a25d5a         | add                 ebx, 0x5a5da228
            //   0545c9ac22           | add                 eax, 0x22acc945
            //   05c26febe9           | add                 eax, 0xe9eb6fc2
            //   81c3417cc57d         | add                 ebx, 0x7dc57c41
            //   2dcb488290           | sub                 eax, 0x908248cb
            //   81c31b4b740f         | add                 ebx, 0xf744b1b

        $sequence_1 = { f7d2 f7d2 33c0 93 899c2440f3ffff 8bd8 }
            // n = 6, score = 100
            //   f7d2                 | not                 edx
            //   f7d2                 | not                 edx
            //   33c0                 | xor                 eax, eax
            //   93                   | xchg                eax, ebx
            //   899c2440f3ffff       | mov                 dword ptr [esp - 0xcc0], ebx
            //   8bd8                 | mov                 ebx, eax

        $sequence_2 = { 2d5f36eba3 05b4cb7144 81c347f7f911 05cae31a61 81eb415d0bcb 05c5fc7980 }
            // n = 6, score = 100
            //   2d5f36eba3           | sub                 eax, 0xa3eb365f
            //   05b4cb7144           | add                 eax, 0x4471cbb4
            //   81c347f7f911         | add                 ebx, 0x11f9f747
            //   05cae31a61           | add                 eax, 0x611ae3ca
            //   81eb415d0bcb         | sub                 ebx, 0xcb0b5d41
            //   05c5fc7980           | add                 eax, 0x8079fcc5

        $sequence_3 = { 81c3747ffb87 055952dc58 2d0b346d09 056fb8227f 81ebd0466de5 }
            // n = 5, score = 100
            //   81c3747ffb87         | add                 ebx, 0x87fb7f74
            //   055952dc58           | add                 eax, 0x58dc5259
            //   2d0b346d09           | sub                 eax, 0x96d340b
            //   056fb8227f           | add                 eax, 0x7f22b86f
            //   81ebd0466de5         | sub                 ebx, 0xe56d46d0

        $sequence_4 = { 6a32 8d36 68???????? 8d12 ff75f8 90 }
            // n = 6, score = 100
            //   6a32                 | push                0x32
            //   8d36                 | lea                 esi, [esi]
            //   68????????           |                     
            //   8d12                 | lea                 edx, [edx]
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   90                   | nop                 

        $sequence_5 = { 81c313bc171f 81c34b9369e2 81c3eb64e095 055b137a14 81eb119d1f79 }
            // n = 5, score = 100
            //   81c313bc171f         | add                 ebx, 0x1f17bc13
            //   81c34b9369e2         | add                 ebx, 0xe269934b
            //   81c3eb64e095         | add                 ebx, 0x95e064eb
            //   055b137a14           | add                 eax, 0x147a135b
            //   81eb119d1f79         | sub                 ebx, 0x791f9d11

        $sequence_6 = { ffd7 83c40c 8d8594fcffff 50 }
            // n = 4, score = 100
            //   ffd7                 | call                edi
            //   83c40c               | add                 esp, 0xc
            //   8d8594fcffff         | lea                 eax, [ebp - 0x36c]
            //   50                   | push                eax

        $sequence_7 = { ff35???????? 7500 56 7500 ffd7 }
            // n = 5, score = 100
            //   ff35????????         |                     
            //   7500                 | jne                 2
            //   56                   | push                esi
            //   7500                 | jne                 2
            //   ffd7                 | call                edi

        $sequence_8 = { 8b842400f1ffff 81eb1705fc0c 90 0545b15a4c 90 2d9acaaf65 }
            // n = 6, score = 100
            //   8b842400f1ffff       | mov                 eax, dword ptr [esp - 0xf00]
            //   81eb1705fc0c         | sub                 ebx, 0xcfc0517
            //   90                   | nop                 
            //   0545b15a4c           | add                 eax, 0x4c5ab145
            //   90                   | nop                 
            //   2d9acaaf65           | sub                 eax, 0x65afca9a

        $sequence_9 = { 81c3ab7990c3 05cb3760e1 81c397e4ecdc 81c3e75ff275 05fbaa91ae 81eb5851999b }
            // n = 6, score = 100
            //   81c3ab7990c3         | add                 ebx, 0xc39079ab
            //   05cb3760e1           | add                 eax, 0xe16037cb
            //   81c397e4ecdc         | add                 ebx, 0xdcece497
            //   81c3e75ff275         | add                 ebx, 0x75f25fe7
            //   05fbaa91ae           | add                 eax, 0xae91aafb
            //   81eb5851999b         | sub                 ebx, 0x9b995158

        $sequence_10 = { 05f1ad59f9 90 81eb704d8e1f 90 81c37208ee7c f7d1 }
            // n = 6, score = 100
            //   05f1ad59f9           | add                 eax, 0xf959adf1
            //   90                   | nop                 
            //   81eb704d8e1f         | sub                 ebx, 0x1f8e4d70
            //   90                   | nop                 
            //   81c37208ee7c         | add                 ebx, 0x7cee0872
            //   f7d1                 | not                 ecx

        $sequence_11 = { f7d2 f7d2 81c31bdfefc0 7500 81eb5daf8042 }
            // n = 5, score = 100
            //   f7d2                 | not                 edx
            //   f7d2                 | not                 edx
            //   81c31bdfefc0         | add                 ebx, 0xc0efdf1b
            //   7500                 | jne                 2
            //   81eb5daf8042         | sub                 ebx, 0x4280af5d

        $sequence_12 = { 05a9b31bec 81c3d6659b48 81eb3e24cc02 05bb9b4196 81eb944686e1 81eb84d90d01 }
            // n = 6, score = 100
            //   05a9b31bec           | add                 eax, 0xec1bb3a9
            //   81c3d6659b48         | add                 ebx, 0x489b65d6
            //   81eb3e24cc02         | sub                 ebx, 0x2cc243e
            //   05bb9b4196           | add                 eax, 0x96419bbb
            //   81eb944686e1         | sub                 ebx, 0xe1864694
            //   81eb84d90d01         | sub                 ebx, 0x10dd984

        $sequence_13 = { ffd7 90 ff75fc 8d36 }
            // n = 4, score = 100
            //   ffd7                 | call                edi
            //   90                   | nop                 
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8d36                 | lea                 esi, [esi]

        $sequence_14 = { 83f8ff 894508 0f8405020000 8b8594fdffff 8b3d???????? 83e010 }
            // n = 6, score = 100
            //   83f8ff               | cmp                 eax, -1
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   0f8405020000         | je                  0x20b
            //   8b8594fdffff         | mov                 eax, dword ptr [ebp - 0x26c]
            //   8b3d????????         |                     
            //   83e010               | and                 eax, 0x10

        $sequence_15 = { 81eb31750679 8d36 81c30378b463 f7d6 f7d6 }
            // n = 5, score = 100
            //   81eb31750679         | sub                 ebx, 0x79067531
            //   8d36                 | lea                 esi, [esi]
            //   81c30378b463         | add                 ebx, 0x63b47803
            //   f7d6                 | not                 esi
            //   f7d6                 | not                 esi

    condition:
        7 of them and filesize < 245760
}