rule win_dmsniff_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dmsniff."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dmsniff"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7508 e8???????? 89c7 6a00 }
            // n = 4, score = 500
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   89c7                 | mov                 edi, eax
            //   6a00                 | push                0

        $sequence_1 = { 57 be19000200 8d45fc 50 56 }
            // n = 5, score = 500
            //   57                   | push                edi
            //   be19000200           | mov                 esi, 0x20019
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_2 = { 40 803c0100 75f9 6a01 50 }
            // n = 5, score = 500
            //   40                   | inc                 eax
            //   803c0100             | cmp                 byte ptr [ecx + eax], 0
            //   75f9                 | jne                 0xfffffffb
            //   6a01                 | push                1
            //   50                   | push                eax

        $sequence_3 = { f7e7 8945f0 50 e8???????? 89c3 81e3ff000000 89de }
            // n = 7, score = 500
            //   f7e7                 | mul                 edi
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   50                   | push                eax
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax
            //   81e3ff000000         | and                 ebx, 0xff
            //   89de                 | mov                 esi, ebx

        $sequence_4 = { eb03 31c0 40 5f 5e c9 }
            // n = 6, score = 500
            //   eb03                 | jmp                 5
            //   31c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               

        $sequence_5 = { 89c7 6a00 6a00 56 53 57 }
            // n = 6, score = 500
            //   89c7                 | mov                 edi, eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   56                   | push                esi
            //   53                   | push                ebx
            //   57                   | push                edi

        $sequence_6 = { 83c41c 89c7 09ff 7507 31c0 }
            // n = 5, score = 500
            //   83c41c               | add                 esp, 0x1c
            //   89c7                 | mov                 edi, eax
            //   09ff                 | or                  edi, edi
            //   7507                 | jne                 9
            //   31c0                 | xor                 eax, eax

        $sequence_7 = { 31c9 8b442408 8a140e 881408 803c0e00 }
            // n = 5, score = 500
            //   31c9                 | xor                 ecx, ecx
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   8a140e               | mov                 dl, byte ptr [esi + ecx]
            //   881408               | mov                 byte ptr [eax + ecx], dl
            //   803c0e00             | cmp                 byte ptr [esi + ecx], 0

        $sequence_8 = { eb3a ff7518 ff7514 ff751c 6a00 }
            // n = 5, score = 500
            //   eb3a                 | jmp                 0x3c
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff751c               | push                dword ptr [ebp + 0x1c]
            //   6a00                 | push                0

        $sequence_9 = { 6a00 68???????? e8???????? 89c7 09ff }
            // n = 5, score = 500
            //   6a00                 | push                0
            //   68????????           |                     
            //   e8????????           |                     
            //   89c7                 | mov                 edi, eax
            //   09ff                 | or                  edi, edi

    condition:
        7 of them and filesize < 131072
}