rule win_dnschanger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dnschanger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dnschanger"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7411 8b4500 68???????? 50 e8???????? 83c408 8b4d00 }
            // n = 7, score = 100
            //   7411                 | je                  0x13
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8b4d00               | mov                 ecx, dword ptr [ebp]

        $sequence_1 = { 8b35???????? ffd6 57 ffd6 5f 32c0 5e }
            // n = 7, score = 100
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   5f                   | pop                 edi
            //   32c0                 | xor                 al, al
            //   5e                   | pop                 esi

        $sequence_2 = { 6a08 ff15???????? 50 ff15???????? 8b6c241c 8b74240c }
            // n = 6, score = 100
            //   6a08                 | push                8
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b6c241c             | mov                 ebp, dword ptr [esp + 0x1c]
            //   8b74240c             | mov                 esi, dword ptr [esp + 0xc]

        $sequence_3 = { 8844240f e8???????? 8b442414 83c40c 89442400 }
            // n = 5, score = 100
            //   8844240f             | mov                 byte ptr [esp + 0xf], al
            //   e8????????           |                     
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   83c40c               | add                 esp, 0xc
            //   89442400             | mov                 dword ptr [esp], eax

        $sequence_4 = { 756b 8b44240c 83f804 7705 be06000000 }
            // n = 5, score = 100
            //   756b                 | jne                 0x6d
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   83f804               | cmp                 eax, 4
            //   7705                 | ja                  7
            //   be06000000           | mov                 esi, 6

        $sequence_5 = { c3 8a44242c 84c0 742d }
            // n = 4, score = 100
            //   c3                   | ret                 
            //   8a44242c             | mov                 al, byte ptr [esp + 0x2c]
            //   84c0                 | test                al, al
            //   742d                 | je                  0x2f

        $sequence_6 = { 6a00 6a03 ff75fc ffd7 }
            // n = 4, score = 100
            //   6a00                 | push                0
            //   6a03                 | push                3
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ffd7                 | call                edi

        $sequence_7 = { 83c408 84c0 7406 b801000000 }
            // n = 4, score = 100
            //   83c408               | add                 esp, 8
            //   84c0                 | test                al, al
            //   7406                 | je                  8
            //   b801000000           | mov                 eax, 1

        $sequence_8 = { eb4e 57 33c0 8d7df8 895df4 }
            // n = 5, score = 100
            //   eb4e                 | jmp                 0x50
            //   57                   | push                edi
            //   33c0                 | xor                 eax, eax
            //   8d7df8               | lea                 edi, [ebp - 8]
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx

        $sequence_9 = { ff15???????? 8d542408 52 e8???????? 85c0 5f 5e }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8d542408             | lea                 edx, [esp + 8]
            //   52                   | push                edx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 49152
}