rule win_dorkbot_ngrbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dorkbot_ngrbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dorkbot_ngrbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3b5dfc 72c5 5f 33c0 5b 8be5 5d }
            // n = 7, score = 200
            //   3b5dfc               | cmp                 ebx, dword ptr [ebp - 4]
            //   72c5                 | jb                  0xffffffc7
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp

        $sequence_1 = { 33f6 68ff030000 8d85e9fbffff 56 50 8975fc }
            // n = 6, score = 200
            //   33f6                 | xor                 esi, esi
            //   68ff030000           | push                0x3ff
            //   8d85e9fbffff         | lea                 eax, [ebp - 0x417]
            //   56                   | push                esi
            //   50                   | push                eax
            //   8975fc               | mov                 dword ptr [ebp - 4], esi

        $sequence_2 = { 56 e8???????? 85c0 7503 5e 5d c3 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7503                 | jne                 5
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_3 = { 68???????? 56 ff15???????? 8b3d???????? 50 ffd7 }
            // n = 6, score = 200
            //   68????????           |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   50                   | push                eax
            //   ffd7                 | call                edi

        $sequence_4 = { 68???????? 68???????? 68???????? e8???????? 83c414 eb49 ff15???????? }
            // n = 7, score = 200
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   eb49                 | jmp                 0x4b
            //   ff15????????         |                     

        $sequence_5 = { 51 6a05 68???????? 52 e8???????? 50 ff15???????? }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   6a05                 | push                5
            //   68????????           |                     
            //   52                   | push                edx
            //   e8????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_6 = { 83c408 3bd8 5b 0f8283000000 68???????? e8???????? }
            // n = 6, score = 200
            //   83c408               | add                 esp, 8
            //   3bd8                 | cmp                 ebx, eax
            //   5b                   | pop                 ebx
            //   0f8283000000         | jb                  0x89
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_7 = { 85c0 7411 2bc2 83e805 894101 c601e9 b805000000 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   2bc2                 | sub                 eax, edx
            //   83e805               | sub                 eax, 5
            //   894101               | mov                 dword ptr [ecx + 1], eax
            //   c601e9               | mov                 byte ptr [ecx], 0xe9
            //   b805000000           | mov                 eax, 5

        $sequence_8 = { 6a40 6800300000 50 53 51 8945f4 }
            // n = 6, score = 200
            //   6a40                 | push                0x40
            //   6800300000           | push                0x3000
            //   50                   | push                eax
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_9 = { 50 e8???????? 83c404 85c0 7e14 8b4cbe10 51 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7e14                 | jle                 0x16
            //   8b4cbe10             | mov                 ecx, dword ptr [esi + edi*4 + 0x10]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 638976
}