rule win_dumador_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dumador"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7754 61 6e 0054414e 3d00000000 005beb 0331 }
            // n = 7, score = 100
            //   7754                 | ja                  0x56
            //   61                   | popal               
            //   6e                   | outsb               dx, byte ptr [esi]
            //   0054414e             | add                 byte ptr [ecx + eax*2 + 0x4e], dl
            //   3d00000000           | cmp                 eax, 0
            //   005beb               | add                 byte ptr [ebx - 0x15], bl
            //   0331                 | add                 esi, dword ptr [ecx]

        $sequence_1 = { e8???????? ff7514 e8???????? 91 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   e8????????           |                     
            //   91                   | xchg                eax, ecx

        $sequence_2 = { 59 e2cb 68???????? 6a02 68???????? e8???????? 68???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   e2cb                 | loop                0xffffffcd
            //   68????????           |                     
            //   6a02                 | push                2
            //   68????????           |                     
            //   e8????????           |                     
            //   68????????           |                     

        $sequence_3 = { c3 e8???????? 6800020000 68???????? }
            // n = 4, score = 100
            //   c3                   | ret                 
            //   e8????????           |                     
            //   6800020000           | push                0x200
            //   68????????           |                     

        $sequence_4 = { c60600 46 e2fa 68???????? }
            // n = 4, score = 100
            //   c60600               | mov                 byte ptr [esi], 0
            //   46                   | inc                 esi
            //   e2fa                 | loop                0xfffffffc
            //   68????????           |                     

        $sequence_5 = { ff7514 e8???????? 91 8b7514 c60600 46 e2fa }
            // n = 7, score = 100
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   e8????????           |                     
            //   91                   | xchg                eax, ecx
            //   8b7514               | mov                 esi, dword ptr [ebp + 0x14]
            //   c60600               | mov                 byte ptr [esi], 0
            //   46                   | inc                 esi
            //   e2fa                 | loop                0xfffffffc

        $sequence_6 = { 3d0074616e 3d00666f72 6d 4e 61 }
            // n = 5, score = 100
            //   3d0074616e           | cmp                 eax, 0x6e617400
            //   3d00666f72           | cmp                 eax, 0x726f6600
            //   6d                   | insd                dword ptr es:[edi], dx
            //   4e                   | dec                 esi
            //   61                   | popal               

        $sequence_7 = { 6800020000 68???????? 50 e8???????? be???????? }
            // n = 5, score = 100
            //   6800020000           | push                0x200
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   be????????           |                     

        $sequence_8 = { 68???????? e8???????? 68???????? 6a01 68???????? }
            // n = 5, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   68????????           |                     
            //   6a01                 | push                1
            //   68????????           |                     

        $sequence_9 = { 00e8 bedcffff83 f8 000f 85f8 0000 008b0d9f4840 }
            // n = 7, score = 100
            //   00e8                 | add                 al, ch
            //   bedcffff83           | mov                 esi, 0x83ffffdc
            //   f8                   | clc                 
            //   000f                 | add                 byte ptr [edi], cl
            //   85f8                 | test                eax, edi
            //   0000                 | add                 byte ptr [eax], al
            //   008b0d9f4840         | add                 byte ptr [ebx + 0x40489f0d], cl

    condition:
        7 of them and filesize < 98304
}