rule win_dustman_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.dustman."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.dustman"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 88480a 488b4c2458 0fb60c08 88480b }
            // n = 4, score = 100
            //   88480a               | jmp                 0x123e
            //   488b4c2458           | dec                 eax
            //   0fb60c08             | lea                 edi, [0x11180]
            //   88480b               | jmp                 0x123e

        $sequence_1 = { eb1e 488bc3 498784f6a0c70100 4885c0 }
            // n = 4, score = 100
            //   eb1e                 | dec                 eax
            //   488bc3               | mov                 ecx, edx
            //   498784f6a0c70100     | dec                 ecx
            //   4885c0               | sub                 ecx, edx

        $sequence_2 = { 488b8dd8000000 0fb60c01 88483b 488b8de0000000 0fb60c01 }
            // n = 5, score = 100
            //   488b8dd8000000       | dec                 eax
            //   0fb60c01             | lea                 ecx, [esp + 0x30]
            //   88483b               | mov                 edx, eax
            //   488b8de0000000       | jne                 0x1cf
            //   0fb60c01             | je                  0x1c7

        $sequence_3 = { 4c0bd0 0fb68523020000 48c1e018 4c0bd0 0fb68524020000 48c1e020 4c0bd0 }
            // n = 7, score = 100
            //   4c0bd0               | dec                 eax
            //   0fb68523020000       | lea                 edx, [0x1620d]
            //   48c1e018             | dec                 ebx
            //   4c0bd0               | lea                 ebx, [esi + esi]
            //   0fb68524020000       | dec                 esp
            //   48c1e020             | mov                 dword ptr [edi + 0x10], esi
            //   4c0bd0               | dec                 esp

        $sequence_4 = { 48898d88000000 488bca 492bca 4c8d9dd2010000 4903cb 48898d90000000 }
            // n = 6, score = 100
            //   48898d88000000       | dec                 ecx
            //   488bca               | mov                 ecx, edi
            //   492bca               | dec                 eax
            //   4c8d9dd2010000       | lea                 edi, [0x158d0]
            //   4903cb               | jmp                 0xf8e
            //   48898d90000000       | dec                 eax

        $sequence_5 = { 8bf2 4c8d0da5830000 488be9 4c8d0593830000 }
            // n = 4, score = 100
            //   8bf2                 | dec                 esp
            //   4c8d0da5830000       | or                  edx, eax
            //   488be9               | movzx               eax, byte ptr [ebp + 0x226]
            //   4c8d0593830000       | dec                 eax

        $sequence_6 = { 488bca 492bca 488db5a2010000 4803f1 }
            // n = 4, score = 100
            //   488bca               | dec                 eax
            //   492bca               | test                ecx, ecx
            //   488db5a2010000       | je                  0x30
            //   4803f1               | dec                 eax

        $sequence_7 = { 488bd8 4883eb02 7826 488bfb }
            // n = 4, score = 100
            //   488bd8               | lea                 ebx, [ebp + 0x1cd]
            //   4883eb02             | dec                 eax
            //   7826                 | mov                 dword ptr [ebp + 0x68], ecx
            //   488bfb               | dec                 eax

        $sequence_8 = { 884831 488b8d90000000 0fb60c01 884832 488b8d98000000 0fb60c01 884833 }
            // n = 7, score = 100
            //   884831               | vsubsd              xmm1, xmm1, xmm2
            //   488b8d90000000       | vmulsd              xmm1, xmm1, qword ptr [ecx + eax*8]
            //   0fb60c01             | jb                  0x1d1
            //   884832               | dec                 eax
            //   488b8d98000000       | shr                 eax, 0x2c
            //   0fb60c01             | dec                 esp
            //   884833               | lea                 ecx, [0x8814]

        $sequence_9 = { 48894d78 488bca 492bca 4c8d9dd0010000 4903cb }
            // n = 5, score = 100
            //   48894d78             | dec                 esp
            //   488bca               | lea                 ebx, [ebp + 0x1d3]
            //   492bca               | dec                 ecx
            //   4c8d9dd0010000       | add                 ecx, ebx
            //   4903cb               | dec                 eax

    condition:
        7 of them and filesize < 368640
}