rule win_eternal_petya_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.eternal_petya."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.eternal_petya"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 6a21 8d460c 50 }
            // n = 4, score = 400
            //   53                   | push                ebx
            //   6a21                 | push                0x21
            //   8d460c               | lea                 eax, [esi + 0xc]
            //   50                   | push                eax

        $sequence_1 = { 55 8bec 51 57 68000000f0 6a18 33ff }
            // n = 7, score = 400
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   57                   | push                edi
            //   68000000f0           | push                0xf0000000
            //   6a18                 | push                0x18
            //   33ff                 | xor                 edi, edi

        $sequence_2 = { 53 68f0000000 6a40 ff15???????? 8bd8 }
            // n = 5, score = 400
            //   53                   | push                ebx
            //   68f0000000           | push                0xf0
            //   6a40                 | push                0x40
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_3 = { 53 8d4644 50 53 }
            // n = 4, score = 400
            //   53                   | push                ebx
            //   8d4644               | lea                 eax, [esi + 0x44]
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_4 = { 49 75f7 8b7508 895de4 }
            // n = 4, score = 300
            //   49                   | dec                 ecx
            //   75f7                 | jne                 0xfffffff9
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx

        $sequence_5 = { 49 75f9 6800400000 56 }
            // n = 4, score = 300
            //   49                   | dec                 ecx
            //   75f9                 | jne                 0xfffffffb
            //   6800400000           | push                0x4000
            //   56                   | push                esi

        $sequence_6 = { 0f86eef9ffff 6afe 58 5f }
            // n = 4, score = 300
            //   0f86eef9ffff         | jbe                 0xfffff9f4
            //   6afe                 | push                -2
            //   58                   | pop                 eax
            //   5f                   | pop                 edi

        $sequence_7 = { 49 75f2 8b4364 034360 8b4b68 894dd4 3bc8 }
            // n = 7, score = 300
            //   49                   | dec                 ecx
            //   75f2                 | jne                 0xfffffff4
            //   8b4364               | mov                 eax, dword ptr [ebx + 0x64]
            //   034360               | add                 eax, dword ptr [ebx + 0x60]
            //   8b4b68               | mov                 ecx, dword ptr [ebx + 0x68]
            //   894dd4               | mov                 dword ptr [ebp - 0x2c], ecx
            //   3bc8                 | cmp                 ecx, eax

        $sequence_8 = { 55 8bec e8???????? 8b4d08 85c9 }
            // n = 5, score = 300
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   e8????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   85c9                 | test                ecx, ecx

        $sequence_9 = { 03c8 8bc2 c1e818 03c8 33c0 }
            // n = 5, score = 300
            //   03c8                 | add                 ecx, eax
            //   8bc2                 | mov                 eax, edx
            //   c1e818               | shr                 eax, 0x18
            //   03c8                 | add                 ecx, eax
            //   33c0                 | xor                 eax, eax

        $sequence_10 = { 03c8 ff442418 ff442410 89940ca0020000 }
            // n = 4, score = 300
            //   03c8                 | add                 ecx, eax
            //   ff442418             | inc                 dword ptr [esp + 0x18]
            //   ff442410             | inc                 dword ptr [esp + 0x10]
            //   89940ca0020000       | mov                 dword ptr [esp + ecx + 0x2a0], edx

        $sequence_11 = { 33db 53 ffd7 50 ff15???????? 5f 8bc3 }
            // n = 7, score = 300
            //   33db                 | xor                 ebx, ebx
            //   53                   | push                ebx
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   8bc3                 | mov                 eax, ebx

        $sequence_12 = { ffd7 a3???????? ffd6 50 6a00 68???????? 6a02 }
            // n = 7, score = 200
            //   ffd7                 | call                edi
            //   a3????????           |                     
            //   ffd6                 | call                esi
            //   50                   | push                eax
            //   6a00                 | push                0
            //   68????????           |                     
            //   6a02                 | push                2

        $sequence_13 = { 8bc6 5e 5b c21000 b8???????? a3???????? }
            // n = 6, score = 200
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c21000               | ret                 0x10
            //   b8????????           |                     
            //   a3????????           |                     

        $sequence_14 = { 8bc6 90 0fb708 66890c03 }
            // n = 4, score = 200
            //   8bc6                 | mov                 eax, esi
            //   90                   | nop                 
            //   0fb708               | movzx               ecx, word ptr [eax]
            //   66890c03             | mov                 word ptr [ebx + eax], cx

        $sequence_15 = { 8bc6 c1f805 57 83e61f 8d3c8500cc4400 }
            // n = 5, score = 200
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   57                   | push                edi
            //   83e61f               | and                 esi, 0x1f
            //   8d3c8500cc4400       | lea                 edi, [eax*4 + 0x44cc00]

    condition:
        7 of them and filesize < 851968
}